/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.component.search.text;

import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import net.anwiba.commons.lang.object.ObjectUtilities;
import net.anwiba.commons.model.IChangeableListListener;
import net.anwiba.commons.model.IObjectListModel;
import net.anwiba.commons.model.IObjectModel;
import net.anwiba.commons.model.ObjectListModel;
import net.anwiba.commons.model.ObjectModel;
import net.anwiba.commons.swing.component.search.ISearchEngine;
import net.anwiba.commons.utilities.string.IStringPart;
import net.anwiba.commons.utilities.string.StringUtilities;

public final class DocumentSearchEngine
implements ISearchEngine<String, IStringPart> {
    private final ObjectModel<IStringPart> resultCursor = new ObjectModel();
    private final ObjectListModel<IStringPart> resultsModel = new ObjectListModel();
    private final Document document;
    private String condition;
    private int currentResultIndex;

    public DocumentSearchEngine(Document document) {
        this.document = document;
        this.document.addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                DocumentSearchEngine.this.update();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                DocumentSearchEngine.this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                DocumentSearchEngine.this.update();
            }
        });
        this.resultsModel.addListModelListener((IChangeableListListener)new IChangeableListListener<IStringPart>(){

            public void objectsRemoved(Iterable<Integer> indeces, Iterable<IStringPart> object) {
                DocumentSearchEngine.this.updateCursor();
            }

            public void objectsAdded(Iterable<Integer> indeces, Iterable<IStringPart> object) {
                DocumentSearchEngine.this.updateCursor();
            }

            public void objectsUpdated(Iterable<Integer> indeces, Iterable<IStringPart> oldObjects, Iterable<IStringPart> newObjects) {
                DocumentSearchEngine.this.updateCursor();
            }

            public void objectsChanged(Iterable<IStringPart> oldObjects, Iterable<IStringPart> newObjects) {
                DocumentSearchEngine.this.updateCursor();
            }
        });
    }

    protected void updateCursor() {
        this.currentResultIndex = this.resultsModel.isEmpty() ? -1 : 0;
        this.resultCursor.set(this.currentResultIndex == -1 ? null : (IStringPart)this.resultsModel.get(this.currentResultIndex));
    }

    @Override
    public boolean hasNext() {
        return this.currentResultIndex != -1 && this.currentResultIndex + 1 < this.resultsModel.size();
    }

    @Override
    public boolean hasPrevious() {
        return this.currentResultIndex != -1 && this.currentResultIndex > 0;
    }

    @Override
    public void next() {
        if (!this.hasNext()) {
            return;
        }
        ++this.currentResultIndex;
        this.resultCursor.set((Object)((IStringPart)this.resultsModel.get(this.currentResultIndex)));
    }

    @Override
    public void previous() {
        if (!this.hasPrevious()) {
            return;
        }
        --this.currentResultIndex;
        this.resultCursor.set((Object)((IStringPart)this.resultsModel.get(this.currentResultIndex)));
    }

    @Override
    public void search(String condition) {
        if (ObjectUtilities.equals((Object)condition, (Object)this.condition)) {
            return;
        }
        this.condition = condition;
        this.update();
    }

    private void update() {
        try {
            if (this.condition == null) {
                this.getSearchResultsModel().removeAll();
                return;
            }
            this.document.getText(0, this.document.getLength());
            String text = this.document.getText(0, this.document.getLength());
            this.resultsModel.set((Iterable)StringUtilities.getStringPositions((String)text, (String)this.condition));
            this.currentResultIndex = this.resultsModel.isEmpty() ? -1 : 0;
        }
        catch (BadLocationException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public IObjectModel<IStringPart> getResultCursorModel() {
        return this.resultCursor;
    }

    @Override
    public boolean hasResult() {
        return this.resultCursor.get() != null;
    }

    @Override
    public String getCondition() {
        return this.condition;
    }

    @Override
    public IObjectListModel<IStringPart> getSearchResultsModel() {
        return this.resultsModel;
    }

    @Override
    public void reset() {
        this.resultsModel.removeAll();
    }
}

