/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.dialog;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import net.anwiba.commons.lang.functional.IBlock;
import net.anwiba.commons.lang.functional.IClosure;
import net.anwiba.commons.lang.functional.IFunction;
import net.anwiba.commons.lang.functional.IProcedure;
import net.anwiba.commons.message.IMessage;
import net.anwiba.commons.model.IObjectModel;
import net.anwiba.commons.model.ObjectModel;
import net.anwiba.commons.preferences.IPreferences;
import net.anwiba.commons.swing.dialog.ConfigurableDialog;
import net.anwiba.commons.swing.dialog.DialogConfigurationBuilder;
import net.anwiba.commons.swing.dialog.DialogMessages;
import net.anwiba.commons.swing.dialog.DialogResult;
import net.anwiba.commons.swing.dialog.DialogType;
import net.anwiba.commons.swing.dialog.IAdditionalActionFactory;
import net.anwiba.commons.swing.dialog.IContentPaneFactory;
import net.anwiba.commons.swing.dialog.IDialogConfiguration;
import net.anwiba.commons.swing.dialog.IDialogLauncher;
import net.anwiba.commons.swing.dialog.IDialogResult;
import net.anwiba.commons.swing.dialog.progress.ProgressDialogLauncher;
import net.anwiba.commons.swing.icon.GuiIcon;
import net.anwiba.commons.swing.icon.IGuiIcon;
import net.anwiba.commons.swing.utilities.GuiUtilities;

public class ConfigurableDialogLauncher
implements IDialogLauncher {
    private final DialogConfigurationBuilder dialogConfigurationBuilder = new DialogConfigurationBuilder();
    private final List<IBlock<RuntimeException>> onCloseExecutables = new ArrayList<IBlock<RuntimeException>>();
    private final List<IProcedure<ConfigurableDialog, RuntimeException>> beforeShowExecutables = new ArrayList<IProcedure<ConfigurableDialog, RuntimeException>>();
    private boolean isProgressDialogEnabled = false;

    public ConfigurableDialogLauncher setDialogIcon(GuiIcon icon) {
        this.dialogConfigurationBuilder.setDialogIcon((IGuiIcon)icon);
        return this;
    }

    public ConfigurableDialogLauncher setIcon(GuiIcon icon) {
        this.dialogConfigurationBuilder.setIcon((IGuiIcon)icon);
        return this;
    }

    public ConfigurableDialogLauncher setCloseButtonDialog() {
        this.dialogConfigurationBuilder.setDialogType(DialogType.CLOSE);
        return this;
    }

    public ConfigurableDialogLauncher setCancleOkButtonDialog() {
        this.dialogConfigurationBuilder.setDialogType(DialogType.CANCEL_OK);
        return this;
    }

    public ConfigurableDialogLauncher setDialogType(DialogType dialogType) {
        this.dialogConfigurationBuilder.setDialogType(dialogType);
        return this;
    }

    public ConfigurableDialogLauncher setActionButtonTextFactory(IFunction<String, String, RuntimeException> factory) {
        this.dialogConfigurationBuilder.setActionButtonTextFactory(factory);
        return this;
    }

    public ConfigurableDialogLauncher setTitle(String title) {
        this.dialogConfigurationBuilder.setTitle(title);
        return this;
    }

    public ConfigurableDialogLauncher setContentPaneFactory(IContentPaneFactory contentPaneFactory) {
        this.dialogConfigurationBuilder.setContentPaneFactory(contentPaneFactory);
        return this;
    }

    public ConfigurableDialogLauncher setPreferences(IPreferences preferences) {
        this.dialogConfigurationBuilder.setPreferences(preferences);
        return this;
    }

    public ConfigurableDialogLauncher enableCloseOnEscape() {
        this.dialogConfigurationBuilder.setDialogCloseKeyEvent(27);
        return this;
    }

    public ConfigurableDialogLauncher setResizeable() {
        this.dialogConfigurationBuilder.setResizeable(true);
        return this;
    }

    public IDialogLauncher setUnresizeable() {
        this.dialogConfigurationBuilder.setResizeable(false);
        return this;
    }

    public ConfigurableDialogLauncher addAdditionalAction(IAdditionalActionFactory factory) {
        this.dialogConfigurationBuilder.addAdditionalAction(factory);
        return this;
    }

    public ConfigurableDialogLauncher setMessage(IMessage message) {
        this.dialogConfigurationBuilder.setMessage(message);
        this.dialogConfigurationBuilder.setMessagePanelEnabled(message != null);
        return this;
    }

    public ConfigurableDialogLauncher setOkButtonText(String string) {
        this.dialogConfigurationBuilder.setActionButtonTextFactory((IFunction<String, String, RuntimeException>)((IFunction)s -> s.equals(DialogMessages.OK) ? string : s));
        return this;
    }

    public ConfigurableDialogLauncher setPreferdSize(int width, int height) {
        this.dialogConfigurationBuilder.setPreferdSize(new Dimension(width, height));
        return this;
    }

    @Override
    public IDialogResult launch(Component component) {
        return this.launch(component == null ? null : SwingUtilities.windowForComponent(component));
    }

    @Override
    public IDialogResult launch(Window owner) {
        ObjectModel model = new ObjectModel();
        GuiUtilities.invokeAndWait(() -> this.lambda$1(owner, (IObjectModel)model));
        return (IDialogResult)model.get();
    }

    public ConfigurableDialogLauncher setApplicationModalExclusionType() {
        this.dialogConfigurationBuilder.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
        return this;
    }

    public ConfigurableDialogLauncher setNoModalExclusionType() {
        this.dialogConfigurationBuilder.setModalExclusionType(Dialog.ModalExclusionType.NO_EXCLUDE);
        return this;
    }

    public ConfigurableDialogLauncher setModelessModality() {
        this.dialogConfigurationBuilder.setModality(Dialog.ModalityType.MODELESS);
        return this;
    }

    public ConfigurableDialogLauncher addOnCloseExecutable(IBlock<RuntimeException> executable) {
        this.onCloseExecutables.add(executable);
        return this;
    }

    public ConfigurableDialogLauncher addBeforeShowExecutable(IProcedure<ConfigurableDialog, RuntimeException> executable) {
        this.beforeShowExecutables.add(executable);
        return this;
    }

    public ConfigurableDialogLauncher setMessagePanelDisabled() {
        this.dialogConfigurationBuilder.setMessagePanelEnabled(false);
        return this;
    }

    public ConfigurableDialogLauncher setProgressDialogEnabled() {
        this.isProgressDialogEnabled = true;
        return this;
    }

    public ConfigurableDialogLauncher setProgressDialogDisabled() {
        this.isProgressDialogEnabled = false;
        return this;
    }

    private /* synthetic */ void lambda$1(Window window, IObjectModel iObjectModel) {
        try {
            IDialogConfiguration configuration = this.dialogConfigurationBuilder.build();
            IClosure closure = () -> {
                ConfigurableDialog configurableDialog = new ConfigurableDialog(window, configuration);
                configurableDialog.setDefaultCloseOperation(2);
                configurableDialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosed(WindowEvent e) {
                        ConfigurableDialogLauncher.this.onCloseExecutables.stream().forEach(b -> b.execute());
                    }
                });
                this.beforeShowExecutables.stream().forEach(b -> b.execute((Object)configurableDialog));
                return configurableDialog;
            };
            ProgressDialogLauncher progressDialogLauncher = new ProgressDialogLauncher((progressMonitor, canceler) -> (ConfigurableDialog)closure.execute());
            ConfigurableDialog dialog = this.isProgressDialogEnabled ? (ConfigurableDialog)progressDialogLauncher.setTitle(configuration.getTitle()).setText("Initialize").setDescription("").launch(window) : (ConfigurableDialog)closure.execute();
            dialog.toFront();
            dialog.setVisible(true);
            iObjectModel.set((Object)dialog.getResult());
        }
        catch (InterruptedException interruptedException) {
            iObjectModel.set((Object)DialogResult.CANCEL);
        }
    }
}

