/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.dialog.chooser;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Window;
import java.lang.reflect.InvocationTargetException;
import java.util.Comparator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import net.anwiba.commons.message.ExceptionMessage;
import net.anwiba.commons.message.IMessage;
import net.anwiba.commons.message.IMessageConstants;
import net.anwiba.commons.message.Message;
import net.anwiba.commons.message.MessageBuilder;
import net.anwiba.commons.message.MessageType;
import net.anwiba.commons.model.IChangeableObjectListener;
import net.anwiba.commons.model.IObjectDistributor;
import net.anwiba.commons.model.IObjectModel;
import net.anwiba.commons.model.ISelectionListener;
import net.anwiba.commons.model.ISelectionModel;
import net.anwiba.commons.model.ObjectModel;
import net.anwiba.commons.model.SelectionEvent;
import net.anwiba.commons.swing.component.IInputListener;
import net.anwiba.commons.swing.dialog.IValueDialog;
import net.anwiba.commons.swing.dialog.MessageDialog;
import net.anwiba.commons.swing.dialog.chooser.ChooserPanelConfigurationUi;
import net.anwiba.commons.swing.dialog.chooser.IChooserDialogConfiguration;
import net.anwiba.commons.swing.dialog.chooser.IChooserPanel;
import net.anwiba.commons.swing.dialog.chooser.IChooserPanelConfiguration;
import net.anwiba.commons.swing.dialog.chooser.IChooserPanelFactory;
import net.anwiba.commons.swing.dialog.chooser.ITryTask;
import net.anwiba.commons.swing.dialog.chooser.ITryTaskFactory;
import net.anwiba.commons.swing.dialog.progress.ProgressDialog;
import net.anwiba.commons.swing.icon.GuiIconSize;
import net.anwiba.commons.swing.icon.GuiIcons;
import net.anwiba.commons.swing.list.ObjectListComponent;
import net.anwiba.commons.swing.list.ObjectListComponentModel;
import net.anwiba.commons.swing.list.ObjectListConfigurationBuilder;
import net.anwiba.commons.utilities.validation.IValidationResult;

public class ListChooserDialog<T>
extends MessageDialog
implements IValueDialog<T> {
    private IChooserPanelConfiguration<T> chooserPanelConfiguration;
    private IObjectModel<T> valueModel = new ObjectModel();
    IObjectDistributor<IValidationResult> validStateModel = new ObjectModel((Object)IValidationResult.valid());
    private IChooserPanel<T> chooserPanel;
    IInputListener inputListener = new IInputListener(){

        @Override
        public void inputHappened() {
            ListChooserDialog.this.setMessage(ListChooserDialog.this.chooserPanel.getMessage());
        }
    };
    private final IChangeableObjectListener valueChangeListener = new IChangeableObjectListener(){

        public void objectChanged() {
            if (!((IValidationResult)ListChooserDialog.this.validStateModel.get()).isValid()) {
                ListChooserDialog.this.setMessage(new MessageBuilder().setText(((IValidationResult)ListChooserDialog.this.validStateModel.get()).getMessage()).setError().build());
                ListChooserDialog.this.setTryEnabled(false);
                ListChooserDialog.this.setOkEnabled(false);
                return;
            }
            ListChooserDialog.this.setMessage(ListChooserDialog.this.chooserPanel.getMessage());
            ListChooserDialog.this.setTryEnabled(ListChooserDialog.this.chooserPanelConfiguration.getTryTaskFactory() != null);
            ListChooserDialog.this.setOkEnabled(true);
        }
    };
    private final IChangeableObjectListener validateStateListener = new IChangeableObjectListener(){

        public void objectChanged() {
            ListChooserDialog.this.setMessage(ListChooserDialog.this.chooserPanel.getMessage());
            if (!((IValidationResult)ListChooserDialog.this.validStateModel.get()).isValid()) {
                ListChooserDialog.this.setTryEnabled(false);
                ListChooserDialog.this.setOkEnabled(false);
                return;
            }
            ListChooserDialog.this.setTryEnabled(ListChooserDialog.this.chooserPanelConfiguration.getTryTaskFactory() != null);
            ListChooserDialog.this.setOkEnabled(true);
        }
    };

    public ListChooserDialog(Window owner, String title, IChooserDialogConfiguration<T> configuration) {
        super(owner, title, IMessageConstants.EMPTY_MESSAGE, (Icon)GuiIcons.EMPTY_ICON.getLargeIcon(), configuration.getDialogType(), true);
        this.valueModel.set(configuration.getPresetValue());
        this.createGui(configuration);
    }

    private void createGui(IChooserDialogConfiguration<T> configuration) {
        ObjectListConfigurationBuilder builder = new ObjectListConfigurationBuilder();
        builder.setObjectUi(new ChooserPanelConfigurationUi(GuiIconSize.LARGE));
        builder.setSingleSelectionMode();
        builder.setHorizontalTextPosition(0);
        builder.setHorizontalAlignment(0);
        builder.setVerticalTextPosition(3);
        builder.setBorder(BorderFactory.createEmptyBorder(4, 0, 2, 0));
        List<IChooserPanelConfiguration<T>> optionPanelConfigurations = configuration.getOptionPanelConfigurations();
        optionPanelConfigurations.sort(new Comparator<IChooserPanelConfiguration<T>>(){

            @Override
            public int compare(IChooserPanelConfiguration<T> o1, IChooserPanelConfiguration<T> o2) {
                return Integer.compare(o1.order(), o2.order());
            }
        });
        ObjectListComponent<IChooserPanelConfiguration<T>> list = new ObjectListComponent<IChooserPanelConfiguration<T>>(builder.build(), new ObjectListComponentModel<IChooserPanelConfiguration<T>>(optionPanelConfigurations));
        JComponent listComponent = list.getComponent();
        final JPanel contentComponent = new JPanel(new GridLayout(1, 1));
        Dimension minimumSize = new Dimension(300, 50);
        listComponent.setMinimumSize(new Dimension(80, 50));
        listComponent.setPreferredSize(new Dimension(80, 50));
        contentComponent.setMinimumSize(minimumSize);
        JPanel contentPanel = (JPanel)this.getContentPane();
        contentPanel.setPreferredSize(new Dimension(480, 300));
        contentPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        contentPanel.setLayout(new BorderLayout(4, 4));
        contentPanel.add("West", listComponent);
        contentPanel.add("Center", contentComponent);
        final ISelectionModel<IChooserPanelConfiguration<T>> selectionModel = list.getSelectionModel();
        if (!optionPanelConfigurations.isEmpty()) {
            selectionModel.setSelectedObject(optionPanelConfigurations.get(0));
            if (this.valueModel.get() != null) {
                for (IChooserPanelConfiguration<T> chooserPanelConfiguration : optionPanelConfigurations) {
                    if (!chooserPanelConfiguration.getOptionPanelFactory().isApplicable(this.valueModel.get())) continue;
                    selectionModel.setSelectedObject(chooserPanelConfiguration);
                    break;
                }
            }
        }
        selectionModel.addSelectionListener(new ISelectionListener<IChooserPanelConfiguration<T>>(){

            public void selectionChanged(SelectionEvent<IChooserPanelConfiguration<T>> event) {
                ListChooserDialog.this.update(contentComponent, selectionModel);
            }
        });
        this.update(contentComponent, selectionModel);
    }

    @Override
    protected boolean tryOut() {
        block6: {
            if (this.chooserPanelConfiguration == null) {
                return super.tryOut();
            }
            ITryTaskFactory<Object> tryTaskFactory = this.chooserPanelConfiguration.getTryTaskFactory();
            this.setTryEnabled(false);
            if (tryTaskFactory == null) {
                return true;
            }
            ITryTask tryTask = tryTaskFactory.create(this.valueModel.get());
            ProgressDialog.show(this, "try", Message.create((String)"try"), tryTask);
            if (!tryTask.isSuccessful()) break block6;
            this.setMessage(Message.create((String)this.chooserPanel.getMessage().getText(), (String)"successful"));
            return true;
        }
        try {
            this.setMessage(Message.create((String)this.chooserPanel.getMessage().getText(), (String)"The connection attempt failed.", (MessageType)MessageType.ERROR));
            this.setOkEnabled(false);
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException exception) {
            this.setOkEnabled(false);
            Throwable targetException = exception.getTargetException();
            this.setMessage((IMessage)new ExceptionMessage(this.chooserPanel.getMessage().getText(), targetException.getLocalizedMessage(), targetException));
            return false;
        }
    }

    void update(JPanel contentComponent, ISelectionModel<IChooserPanelConfiguration<T>> selectionModel) {
        if (this.validStateModel != null) {
            this.validStateModel.removeChangeListener(this.validateStateListener);
        }
        if (this.valueModel != null) {
            this.valueModel.removeChangeListener(this.valueChangeListener);
        }
        if (this.chooserPanel != null) {
            this.chooserPanel.removeInputListener(this.inputListener);
        }
        if (selectionModel.isEmpty()) {
            this.chooserPanelConfiguration = null;
            this.setTryEnabled(false);
            contentComponent.removeAll();
            this.setIcon(null);
            this.setMessage(null);
            this.setTryEnabled(false);
            this.setOkEnabled(false);
            return;
        }
        this.chooserPanelConfiguration = (IChooserPanelConfiguration)selectionModel.getSelectedObjects().iterator().next();
        IChooserPanelFactory<Object> chooserPanelFactory = this.chooserPanelConfiguration.getOptionPanelFactory();
        this.chooserPanel = chooserPanelFactory.create(this.getOwner(), this.valueModel.get());
        this.chooserPanel.addInputListener(this.inputListener);
        this.setIcon(this.chooserPanelConfiguration.getGuiIcon().getLargeIcon());
        this.setMessage(this.chooserPanel.getMessage());
        this.valueModel = this.chooserPanel.getModel();
        this.validStateModel = this.chooserPanel.getValidStateModel();
        this.valueModel.addChangeListener(this.valueChangeListener);
        this.validStateModel.addChangeListener(this.validateStateListener);
        contentComponent.removeAll();
        contentComponent.add(this.chooserPanel.getComponent());
        if (this.valueModel.get() == null || !((IValidationResult)this.validStateModel.get()).isValid()) {
            this.setTryEnabled(false);
            this.setOkEnabled(false);
            return;
        }
        this.setTryEnabled(this.chooserPanelConfiguration.getTryTaskFactory() != null);
        this.setOkEnabled(true);
    }

    @Override
    public T getValue() {
        if (this.valueModel == null) {
            return null;
        }
        this.chooserPanel.savePreferences();
        return (T)this.valueModel.get();
    }
}

