/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.filechooser;

import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.Document;
import net.anwiba.commons.lang.functional.IBlock;
import net.anwiba.commons.lang.functional.IConverter;
import net.anwiba.commons.model.IBooleanDistributor;
import net.anwiba.commons.model.IObjectModel;
import net.anwiba.commons.swing.action.ConfigurableActionBuilder;
import net.anwiba.commons.swing.action.IActionProcedure;
import net.anwiba.commons.swing.filechooser.FileChoosers;
import net.anwiba.commons.swing.filechooser.IFileChooserResult;
import net.anwiba.commons.swing.filechooser.OpenFileChooserConfiguration;
import net.anwiba.commons.swing.filechooser.SaveFileChooserConfiguration;
import net.anwiba.commons.swing.icon.GuiIcons;
import net.anwiba.commons.swing.icon.IGuiIcon;
import net.anwiba.commons.swing.object.AbstractObjectFieldConfigurationBuilder;
import net.anwiba.commons.swing.object.IActionFactory;
import net.anwiba.commons.swing.object.IToolTipFactory;
import net.anwiba.commons.utilities.string.StringUtilities;
import net.anwiba.commons.utilities.validation.IValidationResult;
import net.anwiba.commons.utilities.validation.IValidator;

public class FileFieldConfigurationBuilder
extends AbstractObjectFieldConfigurationBuilder<File, FileFieldConfigurationBuilder> {
    private final List<FileFilter> fileFilters = new ArrayList<FileFilter>();

    public FileFieldConfigurationBuilder() {
        super(new IValidator<String>(){

            public IValidationResult validate(String value) {
                if (!FileFieldConfigurationBuilder.isValid(value)) {
                    return IValidationResult.inValid((String)"Invalid file name");
                }
                return IValidationResult.valid();
            }
        }, new IConverter<String, File, RuntimeException>(){

            public File convert(String input) {
                if (StringUtilities.isNullOrEmpty((String)input)) {
                    return null;
                }
                return new File(input);
            }
        }, new IConverter<File, String, RuntimeException>(){

            public String convert(File input) {
                if (input == null) {
                    return "";
                }
                return input.toString();
            }
        });
        this.setToolTipFactory(new IToolTipFactory(){

            @Override
            public String create(IValidationResult validationResult, String context) throws RuntimeException {
                if (StringUtilities.isNullOrEmpty((String)context)) {
                    return null;
                }
                return context;
            }
        });
    }

    protected static boolean isValid(String value) {
        if (StringUtilities.isNullOrEmpty((String)value)) {
            return true;
        }
        return value.indexOf(0) < 0;
    }

    public FileFieldConfigurationBuilder setFileValidator() {
        this.setValidator(new IValidator<String>(){

            public IValidationResult validate(String value) {
                if (StringUtilities.isNullOrEmpty((String)value)) {
                    return IValidationResult.valid();
                }
                if (!FileFieldConfigurationBuilder.isValid(value)) {
                    return IValidationResult.inValid((String)"Invalid file name");
                }
                File file = new File(value);
                if (!file.isFile()) {
                    return IValidationResult.inValid((String)"Invalid file name");
                }
                boolean flag = FileFieldConfigurationBuilder.this.fileFilters.isEmpty();
                for (FileFilter fileFilter : FileFieldConfigurationBuilder.this.fileFilters) {
                    flag |= fileFilter.accept(file);
                }
                if (!flag) {
                    return IValidationResult.inValid((String)"Invalid folder name");
                }
                return IValidationResult.valid();
            }
        });
        return this;
    }

    public FileFieldConfigurationBuilder setFolderValidator() {
        this.setValidator(new IValidator<String>(){

            public IValidationResult validate(String value) {
                if (StringUtilities.isNullOrEmpty((String)value)) {
                    return IValidationResult.valid();
                }
                if (!FileFieldConfigurationBuilder.isValid(value)) {
                    return IValidationResult.inValid((String)"Invalid file name");
                }
                File file = new File(value);
                if (!file.isDirectory()) {
                    return IValidationResult.inValid((String)"Invalid folder name");
                }
                boolean flag = FileFieldConfigurationBuilder.this.fileFilters.isEmpty();
                for (FileFilter fileFilter : FileFieldConfigurationBuilder.this.fileFilters) {
                    flag |= fileFilter.accept(file);
                }
                if (!flag) {
                    return IValidationResult.inValid((String)"Invalid folder name");
                }
                return IValidationResult.valid();
            }
        });
        return this;
    }

    public FileFieldConfigurationBuilder addFileSaveChooser(final Window owner) {
        this.addActionFactory(new IActionFactory<File>(){

            public AbstractAction create(final IObjectModel<File> context, Document document, IBooleanDistributor enabledDistributor, IBlock<RuntimeException> clearBlock) throws RuntimeException {
                IActionProcedure procedure = new IActionProcedure(){

                    @Override
                    public void execute(Component value) throws RuntimeException {
                        SaveFileChooserConfiguration configuration = new SaveFileChooserConfiguration((File)context.get(), FileFieldConfigurationBuilder.this.fileFilters, 0, FileFieldConfigurationBuilder.this.fileFilters.size() == 0, false);
                        IFileChooserResult result = FileChoosers.show(owner, configuration);
                        if (result.getReturnState() != 0) {
                            return;
                        }
                        context.set((Object)result.getSelectedFile());
                    }
                };
                return new ConfigurableActionBuilder().setEnabledDistributor(enabledDistributor).setIcon((IGuiIcon)GuiIcons.OPEN_ICON).setProcedure(procedure).build();
            }
        });
        return this;
    }

    public FileFieldConfigurationBuilder addFolderSaveChooserAction(final Window owner) {
        this.addActionFactory(new IActionFactory<File>(){

            public AbstractAction create(IObjectModel<File> context, Document document, IBooleanDistributor enabledDistributor, IBlock<RuntimeException> clearBlock) throws RuntimeException {
                IActionProcedure procedure = value -> {
                    SaveFileChooserConfiguration configuration = new SaveFileChooserConfiguration((File)context.get(), Arrays.asList(new FileFilter[0]), 1, false, false);
                    IFileChooserResult result = FileChoosers.show(owner, configuration);
                    if (result.getReturnState() != 0) {
                        return;
                    }
                    context.set((Object)result.getSelectedFile());
                };
                return new ConfigurableActionBuilder().setEnabledDistributor(enabledDistributor).setIcon((IGuiIcon)GuiIcons.FOLDER_ICON).setProcedure(procedure).build();
            }
        });
        return this;
    }

    public FileFieldConfigurationBuilder addFileFilter(FileFilter fileFilter) {
        this.fileFilters.add(fileFilter);
        return this;
    }

    public FileFieldConfigurationBuilder addFileOpenChooserAction(final Window owner) {
        this.addActionFactory(new IActionFactory<File>(){

            public AbstractAction create(IObjectModel<File> context, Document document, IBooleanDistributor enabledDistributor, IBlock<RuntimeException> clearBlock) throws RuntimeException {
                IActionProcedure procedure = value -> {
                    OpenFileChooserConfiguration configuration = new OpenFileChooserConfiguration((File)context.get(), FileFieldConfigurationBuilder.this.fileFilters, 0, false);
                    IFileChooserResult result = FileChoosers.show(owner, configuration);
                    if (result.getReturnState() != 0) {
                        return;
                    }
                    context.set((Object)result.getSelectedFile());
                };
                return new ConfigurableActionBuilder().setEnabledDistributor(enabledDistributor).setIcon((IGuiIcon)GuiIcons.OPEN_ICON).setProcedure(procedure).build();
            }
        });
        return this;
    }

    public FileFieldConfigurationBuilder addFolderOpenChooserAction(final Window owner) {
        this.addActionFactory(new IActionFactory<File>(){

            public AbstractAction create(IObjectModel<File> context, Document document, IBooleanDistributor enabledDistributor, IBlock<RuntimeException> clearBlock) throws RuntimeException {
                IActionProcedure procedure = value -> {
                    OpenFileChooserConfiguration configuration = new OpenFileChooserConfiguration((File)context.get(), FileFieldConfigurationBuilder.this.fileFilters, 1, false);
                    IFileChooserResult result = FileChoosers.show(owner, configuration);
                    if (result.getReturnState() != 0) {
                        return;
                    }
                    context.set((Object)result.getSelectedFile());
                };
                return new ConfigurableActionBuilder().setEnabledDistributor(enabledDistributor).setIcon((IGuiIcon)GuiIcons.FOLDER_ICON).setProcedure(procedure).build();
            }
        });
        return this;
    }
}

