/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.list;

import java.awt.event.MouseListener;
import javax.swing.DropMode;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import net.anwiba.commons.model.ISelectionModel;
import net.anwiba.commons.model.SelectionModel;
import net.anwiba.commons.swing.list.IObjectListConfiguration;
import net.anwiba.commons.swing.ui.IObjectUi;
import net.anwiba.commons.swing.ui.IObjectUiCellRendererConfiguration;
import net.anwiba.commons.swing.ui.ToStringUi;

public class ObjectListConfigurationBuilder<T> {
    private int visibleRowCount = 8;
    private int selectionMode = 2;
    private IObjectUi<T> objectUi = new ToStringUi();
    private int iconTextGap = 2;
    private int verticalAlignment = 0;
    private int verticalTextPosition = 0;
    private int horizontalTextPosition = 11;
    private int horizontalAlignment = 10;
    private Border border = null;
    private int layoutOrientation = 0;
    private MouseListener mouseListener;
    private ISelectionModel<T> selectionModel;
    private TransferHandler transferHandler;
    private boolean isDragEnabled = false;
    private DropMode dropMode = DropMode.USE_SELECTION;
    private T prototype = null;
    IObjectUiCellRendererConfiguration objectUiCellRendererConfiguration = new IObjectUiCellRendererConfiguration(){

        @Override
        public int getVerticalAlignment() {
            return ObjectListConfigurationBuilder.this.verticalAlignment;
        }

        @Override
        public int getVerticalTextPosition() {
            return ObjectListConfigurationBuilder.this.verticalTextPosition;
        }

        @Override
        public int getIconTextGap() {
            return ObjectListConfigurationBuilder.this.iconTextGap;
        }

        @Override
        public int getHorizontalTextPosition() {
            return ObjectListConfigurationBuilder.this.horizontalTextPosition;
        }

        @Override
        public int getHorizontalAlignment() {
            return ObjectListConfigurationBuilder.this.horizontalAlignment;
        }

        @Override
        public Border getBorder() {
            return ObjectListConfigurationBuilder.this.border;
        }
    };

    public ObjectListConfigurationBuilder<T> setObjectUi(IObjectUi<T> objectUi) {
        this.objectUi = objectUi;
        return this;
    }

    public ObjectListConfigurationBuilder<T> setSingleSelectionMode() {
        this.selectionMode = 0;
        return this;
    }

    public ObjectListConfigurationBuilder<T> setSingleIntervalSelectionMode() {
        this.selectionMode = 1;
        return this;
    }

    public ObjectListConfigurationBuilder<T> setMultiSelectionMode() {
        this.selectionMode = 2;
        return this;
    }

    public ObjectListConfigurationBuilder<T> setIconTextGap(int iconTextGap) {
        this.iconTextGap = iconTextGap;
        return this;
    }

    public ObjectListConfigurationBuilder<T> setVerticalTextPosition(int verticalTextPosition) {
        this.verticalTextPosition = verticalTextPosition;
        return this;
    }

    public ObjectListConfigurationBuilder<T> setHorizontalTextPosition(int horizontalTextPosition) {
        this.horizontalTextPosition = horizontalTextPosition;
        return this;
    }

    public ObjectListConfigurationBuilder<T> setHorizontalAlignment(int horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
        return this;
    }

    public ObjectListConfigurationBuilder<T> setHorizontalAlignmentLeft() {
        this.horizontalAlignment = 2;
        return this;
    }

    public ObjectListConfigurationBuilder<T> setHorizontalAlignmentRight() {
        this.horizontalAlignment = 2;
        return this;
    }

    public ObjectListConfigurationBuilder<T> setHorizontalAlignmentCenter() {
        this.horizontalAlignment = 0;
        return this;
    }

    public ObjectListConfigurationBuilder<T> setHorizontalAlignmentLeading() {
        this.horizontalAlignment = 10;
        return this;
    }

    public ObjectListConfigurationBuilder<T> setHorizontalAlignmentTrailing() {
        this.horizontalAlignment = 11;
        return this;
    }

    public ObjectListConfigurationBuilder<T> setBorder(Border border) {
        this.border = border;
        return this;
    }

    public ObjectListConfigurationBuilder<T> setVisibleRowCount(int visibleRowCount) {
        this.visibleRowCount = visibleRowCount;
        return this;
    }

    public ObjectListConfigurationBuilder<T> setVerticalAlignment(int verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
        return this;
    }

    public ObjectListConfigurationBuilder<T> setMouseListener(MouseListener mouseListener) {
        this.mouseListener = mouseListener;
        return this;
    }

    public ObjectListConfigurationBuilder<T> setVerticalOrientation() {
        this.layoutOrientation = 0;
        return this;
    }

    public ObjectListConfigurationBuilder<T> setVerticalWrapOrientation() {
        this.layoutOrientation = 1;
        return this;
    }

    public ObjectListConfigurationBuilder<T> setHorizontalWrapOrientation() {
        this.layoutOrientation = 2;
        return this;
    }

    public ObjectListConfigurationBuilder<T> setTransferHandler(TransferHandler transferHandler) {
        this.transferHandler = transferHandler;
        return this;
    }

    public ObjectListConfigurationBuilder<T> setSelectionModel(ISelectionModel<T> selectionModel) {
        this.selectionModel = selectionModel;
        return this;
    }

    public ObjectListConfigurationBuilder<T> setDragDisabled() {
        this.isDragEnabled = false;
        return this;
    }

    public ObjectListConfigurationBuilder<T> setDragEnabled() {
        this.isDragEnabled = true;
        return this;
    }

    public ObjectListConfigurationBuilder<T> setDropInsertEnabled() {
        this.dropMode = DropMode.INSERT;
        return this;
    }

    public ObjectListConfigurationBuilder<T> setDropReplaceEnabled() {
        this.dropMode = DropMode.ON;
        return this;
    }

    public ObjectListConfigurationBuilder<T> setDropReplaceOrInsertEnabled() {
        this.dropMode = DropMode.ON_OR_INSERT;
        return this;
    }

    public ObjectListConfigurationBuilder<T> setDropToSelectedEnabled() {
        this.dropMode = DropMode.USE_SELECTION;
        return this;
    }

    public ObjectListConfigurationBuilder<T> setPrototype(T prototype) {
        this.prototype = prototype;
        return this;
    }

    public IObjectListConfiguration<T> build() {
        return new IObjectListConfiguration<T>(){

            @Override
            public int getLayoutOrientation() {
                return ObjectListConfigurationBuilder.this.layoutOrientation;
            }

            @Override
            public MouseListener getMouseListener() {
                return ObjectListConfigurationBuilder.this.mouseListener;
            }

            @Override
            public int getVisibleRowCount() {
                return ObjectListConfigurationBuilder.this.visibleRowCount;
            }

            @Override
            public IObjectUi<T> getObjectUi() {
                return ObjectListConfigurationBuilder.this.objectUi;
            }

            @Override
            public int getSelectionMode() {
                return ObjectListConfigurationBuilder.this.selectionMode;
            }

            @Override
            public IObjectUiCellRendererConfiguration getObjectUiCellRendererConfiguration() {
                return ObjectListConfigurationBuilder.this.objectUiCellRendererConfiguration;
            }

            @Override
            public ISelectionModel<T> getSelectionModel() {
                return ObjectListConfigurationBuilder.this.selectionModel == null ? new SelectionModel() : ObjectListConfigurationBuilder.this.selectionModel;
            }

            @Override
            public TransferHandler getTransferHandler() {
                return ObjectListConfigurationBuilder.this.transferHandler;
            }

            @Override
            public DropMode getDropMode() {
                return ObjectListConfigurationBuilder.this.dropMode;
            }

            @Override
            public boolean isDragEnabled() {
                return ObjectListConfigurationBuilder.this.isDragEnabled;
            }

            @Override
            public T getPrototype() {
                return ObjectListConfigurationBuilder.this.prototype;
            }
        };
    }
}

