/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.object;

import java.util.function.Function;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.swing.icons.gnome.contrast.high.ContrastHightIcons;
import net.anwiba.commons.swing.object.AbstractAlgebraicObjectFieldBuilder;
import net.anwiba.commons.swing.object.AbstractObjectTextField;
import net.anwiba.commons.swing.object.DoubleField;
import net.anwiba.commons.swing.object.DoubleObjectFieldConfigurationBuilder;
import net.anwiba.commons.swing.object.IObjectFieldConfiguration;
import net.anwiba.commons.utilities.validation.IValidationResult;

public class DoubleFieldBuilder
extends AbstractAlgebraicObjectFieldBuilder<Double, DoubleObjectFieldConfigurationBuilder, DoubleFieldBuilder> {
    public DoubleFieldBuilder() {
        super(new DoubleObjectFieldConfigurationBuilder());
    }

    @Override
    protected AbstractObjectTextField<Double> create(IObjectFieldConfiguration<Double> configuration) {
        return new DoubleField(configuration);
    }

    public DoubleFieldBuilder addModuloSpinnerActions(int m, double step) {
        return this.addModuloSpinnerActions(m, step, 250, 100);
    }

    public DoubleFieldBuilder addModuloSpinnerActions(int m, double step, int initialDelay, int delay) {
        Function<Double, Double> minus = input -> (Double)Optional.of((Object)input).convert(v1 -> (v1 - step) % (double)m).convert(v2 -> v2 < 0.0 ? v2 + (double)m : v2).convert(v2 -> v2 >= (double)m ? v2 - (double)m : v2).getOr(() -> (double)m - step);
        Function<Double, Boolean> minusEnabler = input -> true;
        this.addButtonFactory(this.createButton(ContrastHightIcons.MINUS, minus, minusEnabler, initialDelay, delay));
        Function<Double, Double> add = input -> (Double)Optional.of((Object)input).convert(v1 -> (v1 + step) % (double)m).convert(v2 -> v2 < 0.0 ? v2 + (double)m : v2).convert(v2 -> v2 >= (double)m ? v2 - (double)m : v2).getOr(() -> 0.0);
        Function<Double, Boolean> addEnabler = input -> true;
        this.addButtonFactory(this.createButton(ContrastHightIcons.ADD, add, addEnabler, initialDelay, delay));
        return this;
    }

    public DoubleFieldBuilder addSliderActions(double minimum, double maximum, double step) {
        return this.addSliderActions(minimum, maximum, step, 250, 100);
    }

    public DoubleFieldBuilder addSliderActions(double minimum, double maximum, double step, int initialDelay, int delay) {
        this.addValidatorFactory(converter -> value -> (IValidationResult)Optional.of((Object)value).convert(v1 -> (Double)converter.convert(v1)).convert(v2 -> this.isValid((Double)v2, minimum, maximum)).getOr(() -> IValidationResult.valid()));
        Function<Double, Double> minus = input -> (Double)Optional.of((Object)input).convert(v1 -> v1 - step).convert(v2 -> v2 < minimum ? minimum : v2).convert(v3 -> v3 > maximum ? maximum : v3).getOr(() -> maximum);
        Function<Double, Boolean> minusEnabler = input -> (Boolean)Optional.of((Object)input).convert(v4 -> v4 > minimum && minimum < maximum).getOr(() -> true);
        this.addButtonFactory(this.createButton(ContrastHightIcons.MINUS, minus, minusEnabler, initialDelay, delay));
        Function<Double, Double> add = input -> (Double)Optional.of((Object)input).convert(v1 -> v1 + step).convert(v2 -> v2 < minimum ? minimum : v2).convert(v3 -> v3 > maximum ? maximum : v3).getOr(() -> minimum);
        Function<Double, Boolean> addEnabler = input -> (Boolean)Optional.of((Object)input).convert(v4 -> v4 < maximum && minimum < maximum).getOr(() -> true);
        this.addButtonFactory(this.createButton(ContrastHightIcons.ADD, add, addEnabler, initialDelay, delay));
        return this;
    }

    private IValidationResult isValid(Double value, double minimum, double maximum) {
        return value < minimum ? IValidationResult.inValid((String)(value + " < " + minimum)) : (value > maximum ? IValidationResult.inValid((String)(value + " > " + maximum)) : IValidationResult.valid());
    }
}

