/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.table;

import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.util.List;
import net.anwiba.commons.model.IBooleanDistributor;
import net.anwiba.commons.model.ISelectionModel;
import net.anwiba.commons.swing.table.IColumnConfiguration;
import net.anwiba.commons.swing.table.IKeyListenerFactory;
import net.anwiba.commons.swing.table.IMouseListenerFactory;
import net.anwiba.commons.swing.table.IObjectTableConfiguration;
import net.anwiba.commons.swing.table.IObjectTableModel;
import net.anwiba.commons.swing.table.ISelectionIndexModel;
import net.anwiba.commons.swing.table.ObjectTableRowSorter;
import net.anwiba.commons.swing.table.action.ITableActionConfiguration;

public class ObjectTableConfiguration<T>
implements IObjectTableConfiguration<T> {
    private final List<? extends IColumnConfiguration> columnConfigurations;
    private final int selectionMode;
    private final ITableActionConfiguration<T> actionConfiguration;
    private final int preferredVisibleRowCount;
    private final IMouseListenerFactory<T> mouseListenerFactory;
    private final IKeyListenerFactory<T> keyListenerFactory;
    private final int autoResizeMode;

    ObjectTableConfiguration(int autoizeMode, int selectionMode, int preferredVisibleRowCount, List<? extends IColumnConfiguration> columnConfigurations, IMouseListenerFactory<T> mouseListenerFactory, IKeyListenerFactory<T> keyListenerFactory, ITableActionConfiguration<T> actionConfiguration) {
        this.autoResizeMode = autoizeMode;
        this.selectionMode = selectionMode;
        this.preferredVisibleRowCount = preferredVisibleRowCount;
        this.columnConfigurations = columnConfigurations;
        this.keyListenerFactory = keyListenerFactory == null ? new IKeyListenerFactory<T>(){

            @Override
            public KeyListener create(IObjectTableModel<T> tableModel, ISelectionIndexModel<T> selectionIndicesProvider, ISelectionModel<T> selectionModel, IBooleanDistributor sortStateModel) {
                return null;
            }
        } : keyListenerFactory;
        this.mouseListenerFactory = mouseListenerFactory == null ? new IMouseListenerFactory<T>(){

            @Override
            public MouseListener create(IObjectTableModel<T> tableModel, ISelectionIndexModel<T> selectionIndicesProvider, ISelectionModel<T> selectionModel, IBooleanDistributor sortStateModel) {
                return null;
            }
        } : mouseListenerFactory;
        this.actionConfiguration = actionConfiguration;
    }

    @Override
    public IColumnConfiguration getColumnConfiguration(int columnIndex) {
        if (columnIndex < 0 || this.columnConfigurations.size() <= columnIndex) {
            return null;
        }
        return this.columnConfigurations.get(columnIndex);
    }

    @Override
    public int getAutoResizeMode() {
        return this.autoResizeMode;
    }

    @Override
    public int getSelectionMode() {
        return this.selectionMode;
    }

    @Override
    public ObjectTableRowSorter<T> getRowSorter(IObjectTableModel<T> tableModel) {
        boolean flag = false;
        ObjectTableRowSorter<T> tableRowSorter = new ObjectTableRowSorter<T>(tableModel);
        int i = 0;
        while (i < this.columnConfigurations.size()) {
            IColumnConfiguration columnConfiguration = this.columnConfigurations.get(i);
            boolean isSortable = columnConfiguration.isSortable();
            tableRowSorter.setSortable(i, isSortable);
            if (columnConfiguration.getComparator() != null) {
                tableRowSorter.setComparator(i, columnConfiguration.getComparator());
            }
            flag |= isSortable;
            ++i;
        }
        return flag ? tableRowSorter : null;
    }

    @Override
    public ITableActionConfiguration<T> getTableActionConfiguration() {
        return this.actionConfiguration;
    }

    @Override
    public int getPreferredVisibleRowCount() {
        return this.preferredVisibleRowCount;
    }

    @Override
    public IMouseListenerFactory<T> getMouseListenerFactory() {
        return this.mouseListenerFactory;
    }

    @Override
    public IKeyListenerFactory<T> getKeyListenerFactory() {
        return this.keyListenerFactory;
    }
}

