/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.table.action;

import javax.swing.AbstractAction;
import javax.swing.Action;
import net.anwiba.commons.lang.primativ.IBooleanProvider;
import net.anwiba.commons.model.IBooleanDistributor;
import net.anwiba.commons.model.IChangeableListListener;
import net.anwiba.commons.model.IChangeableObjectListener;
import net.anwiba.commons.model.ISelectionListener;
import net.anwiba.commons.model.ISelectionModel;
import net.anwiba.commons.model.SelectionEvent;
import net.anwiba.commons.swing.table.IObjectTableModel;
import net.anwiba.commons.swing.table.ISelectionIndexModel;
import net.anwiba.commons.swing.table.action.ITableActionFactory;

public abstract class AbstractTableActionFactory<T>
implements ITableActionFactory<T> {
    @Override
    public Action create(final IObjectTableModel<T> tableModel, final ISelectionIndexModel<T> selectionIndexModel, final ISelectionModel<T> selectionModel, final IBooleanDistributor sortStateModel) {
        final AbstractAction abstractAction = this.createAction(tableModel, selectionModel, selectionIndexModel);
        this.checkEnabled(abstractAction, tableModel, selectionIndexModel, selectionModel, (IBooleanProvider)sortStateModel);
        tableModel.addListModelListener(new IChangeableListListener<T>(){

            public void objectsAdded(Iterable<Integer> indeces, Iterable<T> object) {
                AbstractTableActionFactory.this.checkEnabled(abstractAction, tableModel, selectionIndexModel, selectionModel, (IBooleanProvider)sortStateModel);
            }

            public void objectsRemoved(Iterable<Integer> indeces, Iterable<T> object) {
                AbstractTableActionFactory.this.checkEnabled(abstractAction, tableModel, selectionIndexModel, selectionModel, (IBooleanProvider)sortStateModel);
            }

            public void objectsUpdated(Iterable<Integer> indeces, Iterable<T> oldObjects, Iterable<T> newObjects) {
                AbstractTableActionFactory.this.checkEnabled(abstractAction, tableModel, selectionIndexModel, selectionModel, (IBooleanProvider)sortStateModel);
            }

            public void objectsChanged(Iterable<T> oldObjects, Iterable<T> newObjects) {
                AbstractTableActionFactory.this.checkEnabled(abstractAction, tableModel, selectionIndexModel, selectionModel, (IBooleanProvider)sortStateModel);
            }
        });
        selectionIndexModel.addSelectionListener(new ISelectionListener<T>(){

            public void selectionChanged(SelectionEvent<T> event) {
                AbstractTableActionFactory.this.checkEnabled(abstractAction, tableModel, selectionIndexModel, selectionModel, (IBooleanProvider)sortStateModel);
            }
        });
        sortStateModel.addChangeListener(new IChangeableObjectListener(){

            public void objectChanged() {
                AbstractTableActionFactory.this.checkEnabled(abstractAction, tableModel, selectionIndexModel, selectionModel, (IBooleanProvider)sortStateModel);
            }
        });
        return abstractAction;
    }

    protected abstract void checkEnabled(Action var1, IObjectTableModel<T> var2, ISelectionIndexModel<T> var3, ISelectionModel<T> var4, IBooleanProvider var5);

    protected abstract AbstractAction createAction(IObjectTableModel<T> var1, ISelectionModel<T> var2, ISelectionIndexModel<T> var3);
}

