/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.tree;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import net.anwiba.commons.lang.functional.IAcceptor;
import net.anwiba.commons.swing.tree.IDefaultTreeNodeFilter;
import net.anwiba.commons.swing.tree.IToStringConverter;
import net.anwiba.commons.swing.tree.LazyFolderTreeNode;
import net.anwiba.commons.utilities.collection.ListUtilities;
import net.anwiba.commons.utilities.string.StringUtilities;

public class StringDefaultNodeTreeFilter
implements IDefaultTreeNodeFilter {
    IAcceptor<TreeNode> acceptor;

    public StringDefaultNodeTreeFilter(final String string, final IToStringConverter ... converters) {
        this.acceptor = new IAcceptor<TreeNode>(){

            public boolean accept(TreeNode value) {
                if (StringUtilities.isNullOrEmpty((String)string)) {
                    return true;
                }
                return this.evaluate(value);
            }

            private boolean evaluate(TreeNode node) {
                String upperCase = string.toUpperCase();
                if (node instanceof DefaultMutableTreeNode) {
                    boolean flag = false;
                    IToStringConverter[] iToStringConverterArray = converters;
                    int n = converters.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IToStringConverter toStringConverter = iToStringConverterArray[n2];
                        if (toStringConverter.isApplicable(((DefaultMutableTreeNode)node).getUserObject())) {
                            flag |= this.contains(toStringConverter.toString(((DefaultMutableTreeNode)node).getUserObject()), upperCase);
                        }
                        ++n2;
                    }
                    return flag || this.evaluate(StringDefaultNodeTreeFilter.this.iterable(node));
                }
                return this.contains(node.toString(), upperCase) || this.evaluate(StringDefaultNodeTreeFilter.this.iterable(node));
            }

            private boolean evaluate(Iterable<TreeNode> nodes) {
                for (TreeNode node : nodes) {
                    if (!this.evaluate(node)) continue;
                    return true;
                }
                return false;
            }

            private boolean contains(String upperCase, String value) {
                return value == null ? false : upperCase.contains(value.toUpperCase());
            }
        };
    }

    @Override
    public TreeNode getChild(TreeNode parent, int index) {
        List list = ListUtilities.filter(this.iterable(parent), this.acceptor);
        return (TreeNode)list.get(index);
    }

    Iterable<TreeNode> iterable(final TreeNode parent) {
        if (parent instanceof LazyFolderTreeNode && !((LazyFolderTreeNode)parent).isInitialize()) {
            return () -> new ArrayList().iterator();
        }
        return new Iterable<TreeNode>(){

            @Override
            public Iterator<TreeNode> iterator() {
                final Enumeration<? extends TreeNode> children = parent.children();
                return new Iterator<TreeNode>(){

                    @Override
                    public boolean hasNext() {
                        return children.hasMoreElements();
                    }

                    @Override
                    public TreeNode next() {
                        return (TreeNode)children.nextElement();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public int getIndexOfChild(TreeNode parent, TreeNode child) {
        List list = ListUtilities.filter(this.iterable(parent), this.acceptor);
        return list.indexOf(child);
    }

    @Override
    public int getChildCount(TreeNode parent) {
        List list = ListUtilities.filter(this.iterable(parent), this.acceptor);
        return list.size();
    }
}

