/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.action;

import java.awt.Component;
import java.awt.Window;
import java.lang.reflect.InvocationTargetException;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.message.IMessageCollector;
import net.anwiba.commons.swing.action.IActionConsumer;
import net.anwiba.commons.swing.action.IActionInitializer;
import net.anwiba.commons.swing.action.IActionProcedurBuilder;
import net.anwiba.commons.swing.action.IActionProcedure;
import net.anwiba.commons.swing.action.IActionTask;
import net.anwiba.commons.swing.dialog.progress.ProgressDialogUtilities;
import net.anwiba.commons.swing.utilities.GuiUtilities;
import net.anwiba.commons.swing.utilities.MessageDialogUtilities;
import net.anwiba.commons.utilities.string.StringUtilities;

public class ActionProcedurBuilder<I, O>
implements IActionProcedurBuilder<I, O> {
    private static ILogger logger = Logging.getLogger((String)ActionProcedurBuilder.class.getName());
    private IActionInitializer<I> initializer;
    private IActionTask<I, O> task;
    private IActionConsumer<O> consumer;
    private String title;
    private String description;
    private String errorMessage;

    @Override
    public IActionProcedurBuilder<I, O> setTitle(String title) {
        this.title = title;
        return this;
    }

    @Override
    public IActionProcedurBuilder<I, O> setDescrition(String description) {
        this.description = description;
        return this;
    }

    @Override
    public IActionProcedurBuilder<I, O> setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    @Override
    public IActionProcedurBuilder<I, O> setInitializer(IActionInitializer<I> initializer) {
        this.initializer = initializer;
        return this;
    }

    @Override
    public IActionProcedurBuilder<I, O> setTask(IActionTask<I, O> task) {
        this.task = task;
        return this;
    }

    @Override
    public IActionProcedurBuilder<I, O> setConsumer(IActionConsumer<O> consumer) {
        this.consumer = consumer;
        return this;
    }

    @Override
    public IActionProcedure build() {
        String descrition = StringUtilities.isNullOrTrimmedEmpty((String)this.description) ? this.title : this.description;
        String errorMessage = StringUtilities.isNullOrTrimmedEmpty((String)this.errorMessage) ? String.valueOf(this.description) + ", faild" : this.errorMessage;
        return new ActionProcedur<I, O>(this.title, descrition, errorMessage, this.initializer, this.task, this.consumer);
    }

    public static final class ActionProcedur<I, O>
    implements IActionProcedure {
        private final String title;
        private final IActionConsumer<O> consumer;
        private final IActionInitializer<I> initializer;
        private final String description;
        private final IActionTask<I, O> task;
        private final String errorMessage;

        public ActionProcedur(String title, String descrition, String errorMessage, IActionInitializer<I> initializer, IActionTask<I, O> task, IActionConsumer<O> consumer) {
            this.title = title;
            this.errorMessage = errorMessage;
            this.consumer = consumer;
            this.initializer = initializer;
            this.description = descrition;
            this.task = task;
        }

        @Override
        public void execute(Component component) throws RuntimeException {
            Window owner = GuiUtilities.getParentWindow(component);
            try {
                Object value = Optional.create(this.initializer).convert(i -> i.initialize(component)).get();
                Object result = this.task == null ? value : ProgressDialogUtilities.setTask((progressMonitor, canceler) -> this.task.excecute((IMessageCollector)progressMonitor, canceler, value)).setTitle(this.title).setDescription(this.description).launch(owner);
                Optional.create(this.consumer).consume(c -> c.consume(component, result));
            }
            catch (InvocationTargetException exception) {
                Throwable throwable = exception.getCause();
                logger.log(ILevel.DEBUG, throwable.getMessage(), throwable);
                MessageDialogUtilities.setTitle(this.title).description(this.errorMessage).text(throwable.getMessage()).throwable(throwable).error().launch(owner);
            }
            catch (RuntimeException exception) {
                logger.log(ILevel.DEBUG, exception.getMessage(), (Throwable)exception);
                MessageDialogUtilities.setTitle(this.title).description(this.errorMessage).text(exception.getMessage()).throwable(exception).error().launch(owner);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

