/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.dialog;

import java.awt.BorderLayout;
import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.anwiba.commons.message.IMessage;
import net.anwiba.commons.swing.dialog.MessageUI;
import net.anwiba.commons.swing.icon.GuiIcons;
import net.anwiba.commons.swing.utilities.GuiUtilities;

public class MessagePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final JTextArea messageTextArea = new JTextArea();
    private final JLabel messageTitleLabel = new JLabel();
    private final JLabel messageTypeLabel = new JLabel();
    private final IMessage defaultMessage;
    private Icon icon = GuiIcons.EMPTY_ICON.getLargeIcon();

    public MessagePanel(IMessage defaultMessage, Icon icon) {
        this.defaultMessage = defaultMessage;
        this.setIcon(icon);
        this.setMessage(defaultMessage);
        this.createView();
    }

    protected void createView() {
        JPanel textPanel = new JPanel();
        textPanel.setLayout(new BorderLayout());
        textPanel.setBackground(Color.WHITE);
        textPanel.add("North", this.messageTitleLabel);
        this.messageTextArea.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.messageTextArea.setBackground(Color.WHITE);
        this.messageTextArea.setOpaque(true);
        this.messageTextArea.setColumns(30);
        this.messageTextArea.setRows(2);
        this.messageTextArea.setEditable(false);
        this.messageTextArea.setLineWrap(true);
        this.messageTextArea.setWrapStyleWord(true);
        JScrollPane pane = new JScrollPane(this.messageTextArea);
        pane.setViewportBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        pane.setBorder(BorderFactory.createEmptyBorder(4, 0, 4, 0));
        pane.setBackground(Color.WHITE);
        textPanel.add("Center", pane);
        this.setBorder(BorderFactory.createEmptyBorder(8, 8, 0, 8));
        this.setBackground(Color.WHITE);
        this.setLayout(new BorderLayout());
        this.add("Center", textPanel);
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new BorderLayout());
        labelPanel.setBackground(Color.WHITE);
        labelPanel.add("North", this.messageTypeLabel);
        this.add("East", labelPanel);
    }

    public final void setIcon(Icon icon) {
        if (icon == null) {
            this.icon = GuiIcons.EMPTY_ICON.getLargeIcon();
            return;
        }
        this.icon = icon;
    }

    public final void setMessage(IMessage message) {
        if (message == null) {
            this.setMessage(this.defaultMessage);
            return;
        }
        GuiUtilities.invokeLater(() -> {
            this.messageTitleLabel.setForeground(MessageUI.getColor(message));
            this.messageTitleLabel.setText(message.getText());
            this.messageTextArea.setForeground(MessageUI.getColor(message));
            this.messageTextArea.setText(message.getDescription());
            this.messageTypeLabel.setIcon(MessageUI.getIcon(message, this.getIcon()));
        });
    }

    public final Icon getIcon() {
        return this.icon;
    }
}

