/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.dialog.chooser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Window;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import net.anwiba.commons.message.ExceptionMessage;
import net.anwiba.commons.message.IMessage;
import net.anwiba.commons.message.IMessageConstants;
import net.anwiba.commons.message.Message;
import net.anwiba.commons.message.MessageBuilder;
import net.anwiba.commons.message.MessageType;
import net.anwiba.commons.model.IChangeableObjectListener;
import net.anwiba.commons.model.IObjectDistributor;
import net.anwiba.commons.model.IObjectModel;
import net.anwiba.commons.model.ObjectModel;
import net.anwiba.commons.preferences.IPreferences;
import net.anwiba.commons.swing.combobox.ObjectComboBox;
import net.anwiba.commons.swing.combobox.ObjectComboBoxModel;
import net.anwiba.commons.swing.component.IInputListener;
import net.anwiba.commons.swing.dialog.DataState;
import net.anwiba.commons.swing.dialog.IValueDialog;
import net.anwiba.commons.swing.dialog.MessageDialog;
import net.anwiba.commons.swing.dialog.chooser.ChooserPanelConfigurationUi;
import net.anwiba.commons.swing.dialog.chooser.IChooserDialogConfiguration;
import net.anwiba.commons.swing.dialog.chooser.IChooserPanel;
import net.anwiba.commons.swing.dialog.chooser.IChooserPanelConfiguration;
import net.anwiba.commons.swing.dialog.chooser.IChooserPanelFactory;
import net.anwiba.commons.swing.dialog.chooser.ITryTask;
import net.anwiba.commons.swing.dialog.chooser.ITryTaskFactory;
import net.anwiba.commons.swing.dialog.progress.ProgressDialog;
import net.anwiba.commons.swing.icon.GuiIconSize;
import net.anwiba.commons.swing.icon.GuiIcons;
import net.anwiba.commons.swing.list.ObjectListConfigurationBuilder;
import net.anwiba.commons.swing.preference.IWindowPreferences;
import net.anwiba.commons.swing.preference.WindowPreferences;
import net.anwiba.commons.swing.utilities.GuiUtilities;
import net.anwiba.commons.utilities.validation.IValidationResult;

public class ComboBoxChooserDialog<T>
extends MessageDialog
implements IValueDialog<T> {
    private IChooserPanelConfiguration<T> chooserPanelConfiguration;
    private IObjectModel<T> valueModel = new ObjectModel();
    IObjectDistributor<IValidationResult> validStateModel = new ObjectModel((Object)IValidationResult.valid());
    private IChooserPanel<T> chooserPanel;
    IInputListener inputListener = new IInputListener(){

        @Override
        public void inputHappened() {
            ComboBoxChooserDialog.this.setMessage(ComboBoxChooserDialog.this.chooserPanel.getMessage());
        }
    };
    private final IChangeableObjectListener valueChangeListener = new IChangeableObjectListener(){

        public void objectChanged() {
            if (!((IValidationResult)ComboBoxChooserDialog.this.validStateModel.get()).isValid()) {
                return;
            }
            Object object = ComboBoxChooserDialog.this.valueModel.get();
            if (object == null) {
                ComboBoxChooserDialog.this.setTryEnabled(false);
                ComboBoxChooserDialog.this.setOkEnabled(false);
                return;
            }
            ComboBoxChooserDialog.this.setTryEnabled(ComboBoxChooserDialog.this.chooserPanelConfiguration.getTryTaskFactory() != null);
            ComboBoxChooserDialog.this.setOkEnabled(true);
        }
    };
    private final IChangeableObjectListener validateStateListener = new IChangeableObjectListener(){

        public void objectChanged() {
            if (!((IValidationResult)ComboBoxChooserDialog.this.validStateModel.get()).isValid()) {
                ComboBoxChooserDialog.this.setMessage(new MessageBuilder().setText(((IValidationResult)ComboBoxChooserDialog.this.validStateModel.get()).getMessage()).setError().build());
                ComboBoxChooserDialog.this.setTryEnabled(false);
                ComboBoxChooserDialog.this.setOkEnabled(false);
                return;
            }
            ComboBoxChooserDialog.this.setMessage(ComboBoxChooserDialog.this.chooserPanel.getMessage());
            ComboBoxChooserDialog.this.setTryEnabled(ComboBoxChooserDialog.this.chooserPanelConfiguration.getTryTaskFactory() != null);
            ComboBoxChooserDialog.this.setOkEnabled(true);
        }
    };

    public ComboBoxChooserDialog(Window owner, String title, IChooserDialogConfiguration<T> configuration, IPreferences preferences) {
        super(owner, (IWindowPreferences)new WindowPreferences(preferences), title, IMessageConstants.EMPTY_MESSAGE, (Icon)GuiIcons.EMPTY_ICON.getLargeIcon(), configuration.getDialogType(), Collections.emptyList(), (IObjectModel<DataState>)new ObjectModel(), true);
        this.valueModel.set(configuration.getPresetValue());
        this.createGui(configuration);
    }

    private void createGui(IChooserDialogConfiguration<T> configuration) {
        ObjectListConfigurationBuilder builder = new ObjectListConfigurationBuilder();
        builder.setObjectUi(new ChooserPanelConfigurationUi(GuiIconSize.SMALL));
        builder.setSingleSelectionMode();
        builder.setBorder(BorderFactory.createEmptyBorder(4, 0, 2, 0));
        List<IChooserPanelConfiguration<T>> optionPanelConfigurations = configuration.getOptionPanelConfigurations();
        optionPanelConfigurations.sort(new Comparator<IChooserPanelConfiguration<T>>(){

            @Override
            public int compare(IChooserPanelConfiguration<T> o1, IChooserPanelConfiguration<T> o2) {
                return Integer.compare(o1.order(), o2.order());
            }
        });
        ObjectComboBox<IChooserPanelConfiguration<T>> list = new ObjectComboBox<IChooserPanelConfiguration<T>>(builder.build(), new ObjectComboBoxModel<IChooserPanelConfiguration<T>>(optionPanelConfigurations));
        JComponent comboBoxComponent = list.getComponent();
        final JPanel contentComponent = new JPanel(new GridLayout(1, 1));
        Dimension minimumSize = new Dimension(300, 50);
        comboBoxComponent.setMinimumSize(new Dimension(150, 30));
        comboBoxComponent.setPreferredSize(new Dimension(150, 30));
        contentComponent.setMinimumSize(minimumSize);
        JPanel comboBoxComponentContainer = new JPanel(new BorderLayout());
        comboBoxComponentContainer.add((Component)comboBoxComponent, "North");
        JPanel contentPanel = (JPanel)this.getContentPane();
        contentPanel.setPreferredSize(new Dimension(480, 200));
        contentPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        contentPanel.setLayout(new BorderLayout(4, 4));
        contentPanel.add("North", comboBoxComponentContainer);
        contentPanel.add("Center", contentComponent);
        final IObjectModel<IChooserPanelConfiguration<T>> selectionModel = list.getSelectionModel();
        if (!optionPanelConfigurations.isEmpty()) {
            selectionModel.set(optionPanelConfigurations.get(0));
            if (this.valueModel.get() != null) {
                for (IChooserPanelConfiguration<T> chooserPanelConfiguration : optionPanelConfigurations) {
                    if (!chooserPanelConfiguration.getOptionPanelFactory().isApplicable(this.valueModel.get())) continue;
                    selectionModel.set(chooserPanelConfiguration);
                    break;
                }
            }
        }
        selectionModel.addChangeListener(new IChangeableObjectListener(){

            public void objectChanged() {
                ComboBoxChooserDialog.this.update(contentComponent, selectionModel);
            }
        });
        this.update(contentComponent, selectionModel);
    }

    @Override
    protected boolean tryOut() {
        block6: {
            if (this.chooserPanelConfiguration == null) {
                return super.tryOut();
            }
            ITryTaskFactory<Object> tryTaskFactory = this.chooserPanelConfiguration.getTryTaskFactory();
            this.setTryEnabled(false);
            if (tryTaskFactory == null) {
                return true;
            }
            ITryTask tryTask = tryTaskFactory.create(this.valueModel.get());
            ProgressDialog.show(this, "try", Message.create((String)"try"), tryTask);
            if (!tryTask.isSuccessful()) break block6;
            this.setMessage(Message.create((String)this.chooserPanel.getMessage().getText(), (String)"successful"));
            return true;
        }
        try {
            this.setMessage(Message.create((String)this.chooserPanel.getMessage().getText(), (String)"The connection attempt failed.", (MessageType)MessageType.ERROR));
            this.setOkEnabled(false);
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException exception) {
            this.setOkEnabled(false);
            Throwable targetException = exception.getTargetException();
            this.setMessage((IMessage)new ExceptionMessage(this.chooserPanel.getMessage().getText(), targetException.getLocalizedMessage(), targetException));
            return false;
        }
    }

    void update(JPanel contentComponent, IObjectModel<IChooserPanelConfiguration<T>> selectionModel) {
        if (this.validStateModel != null) {
            this.validStateModel.removeChangeListener(this.validateStateListener);
        }
        if (this.valueModel != null) {
            this.valueModel.removeChangeListener(this.valueChangeListener);
        }
        if (this.chooserPanel != null) {
            this.chooserPanel.removeInputListener(this.inputListener);
        }
        if (selectionModel.get() == null) {
            this.chooserPanelConfiguration = null;
            GuiUtilities.invokeLater(() -> {
                this.setTryEnabled(false);
                contentComponent.removeAll();
                this.setIcon(null);
                this.setMessage(null);
                this.setTryEnabled(false);
                this.setOkEnabled(false);
                this.validate();
                this.doLayout();
            });
            return;
        }
        this.chooserPanelConfiguration = (IChooserPanelConfiguration)selectionModel.get();
        IChooserPanelFactory<Object> chooserPanelFactory = this.chooserPanelConfiguration.getOptionPanelFactory();
        this.chooserPanel = chooserPanelFactory.create(this.getOwner(), this.valueModel.get());
        this.chooserPanel.addInputListener(this.inputListener);
        this.valueModel = this.chooserPanel.getModel();
        this.validStateModel = this.chooserPanel.getValidStateModel();
        this.valueModel.addChangeListener(this.valueChangeListener);
        this.validStateModel.addChangeListener(this.validateStateListener);
        GuiUtilities.invokeLater(() -> {
            try {
                this.setIcon(this.chooserPanelConfiguration.getGuiIcon().getLargeIcon());
                this.setMessage(this.chooserPanel.getMessage());
                contentComponent.removeAll();
                contentComponent.add(this.chooserPanel.getComponent());
                if (this.valueModel.get() == null || !((IValidationResult)this.validStateModel.get()).isValid()) {
                    this.setTryEnabled(false);
                    this.setOkEnabled(false);
                    return;
                }
                this.setTryEnabled(this.chooserPanelConfiguration.getTryTaskFactory() != null);
                this.setOkEnabled(true);
            }
            finally {
                this.validate();
                this.doLayout();
            }
        });
    }

    @Override
    public T getValue() {
        if (this.valueModel == null) {
            return null;
        }
        this.chooserPanel.savePreferences();
        return (T)this.valueModel.get();
    }
}

