/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.dialog.wizard;

import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import net.anwiba.commons.lang.functional.IApplicable;
import net.anwiba.commons.lang.object.ObjectUtilities;
import net.anwiba.commons.model.IObjectModel;
import net.anwiba.commons.model.ISelectionListener;
import net.anwiba.commons.model.SelectionEvent;
import net.anwiba.commons.model.SelectionModel;
import net.anwiba.commons.swing.dialog.DataState;
import net.anwiba.commons.swing.dialog.wizard.AbstractWizardPage;
import net.anwiba.commons.swing.dialog.wizard.IWizardAction;
import net.anwiba.commons.swing.dialog.wizard.IWizardController;
import net.anwiba.commons.swing.dialog.wizard.IWizardPage;
import net.anwiba.commons.swing.list.IObjectListConfiguration;
import net.anwiba.commons.swing.list.ObjectListComponent;
import net.anwiba.commons.swing.list.ObjectListComponentModel;
import net.anwiba.commons.swing.list.ObjectListConfigurationBuilder;
import net.anwiba.commons.swing.ui.IObjectUi;

public class ChooseOneOfManyWizardPage<T>
extends AbstractWizardPage {
    private final boolean finishable;
    private final IObjectModel<T> mobel;
    private final List<T> values;
    private final IObjectUi<T> objectUi;
    private final T originalValue;
    private JPanel component;
    private final IObjectModel<IWizardAction> wizardActionModel;

    public ChooseOneOfManyWizardPage(String title, String message, Icon icon, DataState state, boolean finishable, IObjectUi<T> objectUi, List<T> values, IObjectModel<T> mobel, IObjectModel<IWizardAction> wizardActionModel, IApplicable<IWizardPage> applicable) {
        super(title, message, icon, applicable);
        this.finishable = finishable;
        this.objectUi = objectUi;
        this.values = values;
        this.mobel = mobel;
        this.wizardActionModel = wizardActionModel;
        this.originalValue = mobel.get();
        this.getNextEnabledModel().set(this.originalValue != null);
        this.getDataStateModel().set((Object)(this.originalValue == null ? DataState.UNKNOWN : state));
    }

    @Override
    public JComponent getComponent() {
        if (this.component != null) {
            return this.component;
        }
        this.component = new JPanel(new GridLayout(1, 1, 5, 5));
        this.component.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        final SelectionModel selectionModel = new SelectionModel();
        IObjectListConfiguration configuration = new ObjectListConfigurationBuilder<T>().setObjectUi(this.objectUi).setSelectionModel(selectionModel).setMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent event) {
                if (selectionModel.isEmpty()) {
                    return;
                }
                if (event.getButton() == 1 && event.getClickCount() == 2) {
                    ChooseOneOfManyWizardPage.this.wizardActionModel.set((Object)new IWizardAction(){

                        @Override
                        public void execute(IWizardController controller) {
                            if (controller.hasNext() && controller.getNextEnabledDistributor().get()) {
                                controller.next();
                            }
                        }
                    });
                }
            }
        }).setSingleSelectionMode().build();
        ObjectListComponent listComponent = new ObjectListComponent(configuration, new ObjectListComponentModel<T>(this.values));
        selectionModel.addSelectionListener(new ISelectionListener<T>(){

            public void selectionChanged(SelectionEvent<T> event) {
                Iterator iterator = event.getSource().getSelectedObjects().iterator();
                Object object = iterator.hasNext() ? iterator.next() : null;
                ChooseOneOfManyWizardPage.this.mobel.set(object);
                DataState state = ChooseOneOfManyWizardPage.this.mobel.get() == null ? DataState.INVALIDE : (ObjectUtilities.equals(object, (Object)ChooseOneOfManyWizardPage.this.originalValue) ? DataState.VALIDE : DataState.MODIFIED);
                ChooseOneOfManyWizardPage.this.getDataStateModel().set((Object)state);
                ChooseOneOfManyWizardPage.this.getNextEnabledModel().set(DataState.VALIDE.equals((Object)state) || DataState.MODIFIED.equals((Object)state));
            }
        });
        selectionModel.setSelectedObject(this.originalValue);
        this.component.add(listComponent.getComponent());
        return this.component;
    }

    @Override
    public boolean finishable() {
        return this.finishable;
    }
}

