/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.image;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.Scrollable;
import javax.swing.border.Border;
import net.anwiba.commons.image.BufferedImageContainer;
import net.anwiba.commons.image.IImageContainer;
import net.anwiba.commons.image.IImageReader;
import net.anwiba.commons.image.ImageFileFilter;
import net.anwiba.commons.image.graphic.ClosableGraphicsBuider;
import net.anwiba.commons.image.graphic.IClosableGraphics;
import net.anwiba.commons.lang.functional.IConverter;
import net.anwiba.commons.lang.object.ObjectUtilities;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.model.IObjectModel;
import net.anwiba.commons.model.ObjectModel;
import net.anwiba.commons.reference.IResourceReference;
import net.anwiba.commons.reference.ResourceReferenceUtilities;
import net.anwiba.commons.swing.icon.GuiIcons;
import net.anwiba.commons.swing.image.ImagePanelMessages;
import net.anwiba.commons.swing.image.ImageScaleBehavior;
import net.anwiba.commons.swing.utilities.GuiUtilities;
import net.anwiba.commons.thread.cancel.Canceler;

public class ImagePanel
extends JComponent
implements Scrollable {
    private static ILogger logger = Logging.getLogger(ImagePanel.class);
    private final IObjectModel<IImageContainer> imageContainerModel = new ObjectModel();
    private BufferedImage thumbnail = null;
    private Thread thread = null;
    private final ImageScaleBehavior scaleUp;
    private Rectangle bound;
    private int maxUnitIncrement = 2;
    private final IImageReader imageReader;

    public ImagePanel(IImageReader imageReader, IObjectModel<IResourceReference> imageFileModel) {
        this(imageReader, imageFileModel, ImageScaleBehavior.FIT);
    }

    public ImagePanel(IImageReader imageReader, final IObjectModel<IResourceReference> imageFileModel, ImageScaleBehavior scaleUp) {
        this.setAutoscrolls(true);
        this.imageReader = imageReader;
        this.scaleUp = scaleUp;
        final ImageFileFilter fileFilter = new ImageFileFilter();
        this.setPreferredSize(new Dimension(100, 100));
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        imageFileModel.addChangeListener(() -> {
            this.reset();
            this.load(imageFileModel, fileFilter);
        });
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent e) {
                ImagePanel.this.load((IObjectModel<IResourceReference>)imageFileModel, fileFilter);
            }

            @Override
            public void componentResized(ComponentEvent e) {
                ImagePanel.this.load((IObjectModel<IResourceReference>)imageFileModel, fileFilter);
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                ImagePanel.this.reset();
            }
        });
    }

    protected void load(IObjectModel<IResourceReference> imageFileModel, ImageFileFilter fileFilter) {
        IResourceReference imageFile = (IResourceReference)imageFileModel.get();
        if (this.thread != null) {
            this.thread.interrupt();
        }
        if (this.isAccepted(fileFilter, imageFile)) {
            this.thread = new Thread(() -> {
                block3: {
                    try {
                        if (this.loadImage(imageFile)) {
                            GuiUtilities.invokeLater(() -> this.repaint());
                        }
                    }
                    catch (IOException e) {
                        logger.log(ILevel.DEBUG, e.getMessage(), (Throwable)e);
                        final Image image = GuiIcons.ERROR_ICON.getLargeIcon().getImage();
                        BufferedImage bufferedImage = image instanceof BufferedImage ? (BufferedImage)image : new IConverter<Image, BufferedImage, RuntimeException>(){

                            public BufferedImage convert(Image input) throws RuntimeException {
                                BufferedImage bufferdImage = new BufferedImage(100, 60, 2);
                                Graphics2D g = bufferdImage.createGraphics();
                                try {
                                    g.drawImage(image, 50 - image.getWidth(null) / 2, 0, null);
                                    g.setColor(Color.BLACK);
                                    String errorMessage = ImagePanelMessages.ReadingFaild;
                                    Rectangle2D bounds = ImagePanel.this.getFontMetrics(ImagePanel.this.getFont()).getStringBounds(errorMessage, g);
                                    ((Graphics)g).drawString(errorMessage, (int)(50.0 - bounds.getWidth() / 2.0), (int)(60.0 - bounds.getHeight() - 2.0));
                                }
                                finally {
                                    g.dispose();
                                }
                                return bufferdImage;
                            }
                        }.convert(image);
                        this.imageContainerModel.set((Object)new BufferedImageContainer(bufferedImage));
                        if (!this.update()) break block3;
                        GuiUtilities.invokeLater(() -> this.repaint());
                    }
                }
            });
            this.thread.start();
        }
    }

    private boolean isAccepted(ImageFileFilter fileFilter, IResourceReference imageFile) {
        try {
            if (ResourceReferenceUtilities.isFileSystemResource((IResourceReference)imageFile)) {
                File file = ResourceReferenceUtilities.getFile((IResourceReference)imageFile);
                return file != null && file.isFile() && fileFilter.accept(file);
            }
            return imageFile != null;
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reset() {
        ImagePanel imagePanel = this;
        synchronized (imagePanel) {
            if (this.imageContainerModel.get() != null) {
                ((IImageContainer)this.imageContainerModel.get()).dispose();
            }
            this.imageContainerModel.set(null);
            this.thumbnail = null;
        }
        GuiUtilities.invokeLater(() -> this.repaint());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean loadImage(IResourceReference imageFile) throws IOException {
        ImagePanel imagePanel = this;
        synchronized (imagePanel) {
            if (this.imageContainerModel.get() == null) {
                try {
                    IImageContainer container = this.imageReader.read(Canceler.DummyCanceler, imageFile);
                    if (container == null) {
                        return false;
                    }
                    this.imageContainerModel.set((Object)container);
                }
                catch (InterruptedException interruptedException) {
                    return false;
                }
            }
            return this.update();
        }
    }

    private boolean update() {
        BufferedImage bufferImage;
        IImageContainer imageContainer;
        block3: {
            try {
                imageContainer = (IImageContainer)this.imageContainerModel.get();
                int imageWidth = imageContainer.getWidth();
                int imageHeight = imageContainer.getHeight();
                this.bound = this.imageBound(imageWidth, imageHeight);
                if (this.thumbnail == null || this.thumbnail.getWidth() != this.bound.width || this.thumbnail.getHeight() != this.bound.height) break block3;
                return true;
            }
            catch (Exception exception) {
                logger.log(ILevel.DEBUG, exception.getMessage(), (Throwable)exception);
                return false;
            }
        }
        this.thumbnail = bufferImage = imageContainer.fit(this.bound.width, this.bound.height).asBufferImage();
        return true;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.bound != null && this.thumbnail != null) {
            Throwable throwable = null;
            Object var3_4 = null;
            try (IClosableGraphics graphic = new ClosableGraphicsBuider((Graphics2D)g.create()).setColorRenderQuality().setStrokeControlNormalize().setAntiAliasingOn().setAlphaInterpolationQuality().setTextAntiAliasing(true).setDitheringEnabled().setRenderingQuality().build();){
                graphic.drawImage((Image)this.thumbnail, this.bound.x, this.bound.y, (ImageObserver)this);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private synchronized Rectangle imageBound(int imageWidth, int imageHeight) {
        Border border = this.getBorder();
        Insets insets = border != null ? border.getBorderInsets(this) : new Insets(0, 0, 0, 0);
        double imageAspectRatio = (double)imageWidth / (double)imageHeight;
        double panelAspectRatio = (double)this.getWidth() / (double)this.getHeight();
        int x = 0;
        int y = 0;
        Container parent = this.getParent();
        Dimension size = parent != null ? parent.getSize() : new Dimension(256, 256);
        int width = size.width - insets.left - insets.right;
        int height = size.height - insets.top - insets.bottom;
        if (!ObjectUtilities.equals((Object)((Object)this.scaleUp), (Object)((Object)ImageScaleBehavior.FIT)) && imageWidth < width && imageHeight < height) {
            this.setMinimumSize(new Dimension(width, height));
            this.setPreferredSize(new Dimension(width, height));
            this.setMaximumSize(new Dimension(width, height));
            if (this.getParent() != null) {
                GuiUtilities.invokeLater(() -> this.getParent().doLayout());
            }
            x = (width - imageWidth) / 2;
            y = (height - imageHeight) / 2;
            return new Rectangle(x, y, imageWidth, imageHeight);
        }
        if (ObjectUtilities.equals((Object)((Object)this.scaleUp), (Object)((Object)ImageScaleBehavior.ORGIN))) {
            this.setMinimumSize(new Dimension(imageWidth, imageHeight));
            this.setPreferredSize(new Dimension(imageWidth, imageHeight));
            this.setMaximumSize(new Dimension(imageWidth, imageHeight));
            if (this.getParent() != null) {
                GuiUtilities.invokeLater(() -> this.getParent().doLayout());
            }
            return new Rectangle(0, 0, imageWidth, imageHeight);
        }
        this.setMinimumSize(new Dimension(width, height));
        this.setPreferredSize(new Dimension(width, height));
        this.setMaximumSize(new Dimension(width, height));
        if (this.getParent() != null) {
            GuiUtilities.invokeLater(() -> this.getParent().doLayout());
        }
        if (imageAspectRatio < panelAspectRatio) {
            height = this.getHeight() - insets.top - insets.bottom;
            width = (int)((double)height * imageAspectRatio);
            x = (this.getWidth() - insets.left - insets.right - width) / 2;
            y = insets.top;
        } else {
            width = this.getWidth() - insets.left - insets.right;
            height = (int)((double)width / imageAspectRatio);
            x = insets.left;
            y = (this.getHeight() - insets.top - insets.bottom - height) / 2;
        }
        return new Rectangle(x, y, width, height);
    }

    public IObjectModel<IImageContainer> getImageContainerModel() {
        return this.imageContainerModel;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 0) {
            return visibleRect.width - this.maxUnitIncrement;
        }
        return visibleRect.height - this.maxUnitIncrement;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public void setMaxUnitIncrement(int pixels) {
        this.maxUnitIncrement = pixels;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        Dimension size;
        Container parent = this.getParent();
        Dimension dimension = size = parent != null ? parent.getSize() : new Dimension(256, 256);
        if (this.imageContainerModel.get() != null) {
            switch (this.scaleUp) {
                case ORGIN: {
                    IImageContainer imageContainer = (IImageContainer)this.imageContainerModel.get();
                    int imageWidth = imageContainer.getWidth();
                    int imageHeight = imageContainer.getHeight();
                    return size.width > imageWidth && size.height > imageHeight ? size : new Dimension(imageWidth, imageHeight);
                }
            }
        }
        return size;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        int currentPosition = 0;
        currentPosition = orientation == 0 ? visibleRect.x : visibleRect.y;
        if (direction < 0) {
            int newPosition = currentPosition - currentPosition / this.maxUnitIncrement * this.maxUnitIncrement;
            return newPosition == 0 ? this.maxUnitIncrement : newPosition;
        }
        return (currentPosition / this.maxUnitIncrement + 1) * this.maxUnitIncrement - currentPosition;
    }
}

