/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.object;

import java.text.MessageFormat;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import net.anwiba.commons.lang.functional.IConverter;
import net.anwiba.commons.lang.optional.If;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.model.IChangeableObjectListener;
import net.anwiba.commons.model.IObjectDistributor;
import net.anwiba.commons.model.IObjectModel;
import net.anwiba.commons.model.ObjectModel;
import net.anwiba.commons.swing.object.DoubleFieldBuilder;
import net.anwiba.commons.swing.object.IObjectField;
import net.anwiba.commons.swing.object.ObjectFieldMessages;
import net.anwiba.commons.swing.utilities.SpringLayoutUtilities;
import net.anwiba.commons.utilities.interval.DoubleInterval;
import net.anwiba.commons.utilities.number.StringToDoubleConverter;
import net.anwiba.commons.utilities.validation.IValidationResult;
import net.anwiba.commons.utilities.validation.IValidator;

public class DoubleIntervalField
implements IObjectField<DoubleInterval> {
    private static ILogger logger = Logging.getLogger((String)DoubleIntervalField.class.getName());
    private final IObjectModel<IValidationResult> validationResultModel;
    private final IObjectModel<IValidationResult> minimumValidationModel = new ObjectModel((Object)IValidationResult.valid());
    private final IObjectModel<IValidationResult> maximumValidationModel = new ObjectModel((Object)IValidationResult.valid());
    private final IObjectModel<Double> minimumValueModel = new ObjectModel();
    private final IObjectModel<Double> maximumValueModel = new ObjectModel();
    private final IObjectModel<DoubleInterval> model;
    private JPanel component;
    private final double maximum;
    private final double minimum;
    private final double stepSize;
    private final IConverter<Double, String, RuntimeException> toStringFormater;

    public DoubleIntervalField(IConverter<Double, String, RuntimeException> toStringFormater, double minimum, double maximum, double stepSize, final IObjectModel<DoubleInterval> model, final IObjectModel<IValidationResult> validationModel) {
        this.stepSize = stepSize;
        this.model = model;
        this.minimum = minimum;
        this.maximum = maximum;
        this.toStringFormater = toStringFormater;
        this.validationResultModel = validationModel;
        this.minimumValueModel.set(model.get() == null ? null : Double.valueOf(((DoubleInterval)model.get()).getMinimum()));
        this.maximumValueModel.set(model.get() == null ? null : Double.valueOf(((DoubleInterval)model.get()).getMaximum()));
        validationModel.set((Object)this.checkValid());
        IChangeableObjectListener validationListener = new IChangeableObjectListener(){

            public void objectChanged() {
                logger.log(ILevel.DEBUG, "validation state changed");
                logger.log(ILevel.DEBUG, MessageFormat.format("minimum value: {0}", ((IValidationResult)DoubleIntervalField.this.minimumValidationModel.get()).isValid() ? "valid" : MessageFormat.format("invalid: {0}", ((IValidationResult)DoubleIntervalField.this.minimumValidationModel.get()).getMessage())));
                logger.log(ILevel.DEBUG, "maximum value: " + (((IValidationResult)DoubleIntervalField.this.maximumValidationModel.get()).isValid() ? "valid" : MessageFormat.format("invalid: {0}", ((IValidationResult)DoubleIntervalField.this.maximumValidationModel.get()).getMessage())));
                if (!((IValidationResult)DoubleIntervalField.this.minimumValidationModel.get()).isValid()) {
                    validationModel.set((Object)IValidationResult.inValid((String)(String.valueOf(ObjectFieldMessages.IllegalMinimumValue) + ((IValidationResult)DoubleIntervalField.this.minimumValidationModel.get()).getMessage())));
                    return;
                }
                if (!((IValidationResult)DoubleIntervalField.this.maximumValidationModel.get()).isValid()) {
                    validationModel.set((Object)IValidationResult.inValid((String)(String.valueOf(ObjectFieldMessages.IllegalMaximumValue) + ((IValidationResult)DoubleIntervalField.this.maximumValidationModel.get()).getMessage())));
                    return;
                }
                IValidationResult validationResult = DoubleIntervalField.this.checkValid();
                if (validationResult.isValid()) {
                    model.set(DoubleIntervalField.this.minimumValueModel.get() == null && DoubleIntervalField.this.maximumValueModel.get() == null ? null : new DoubleInterval(((Double)DoubleIntervalField.this.minimumValueModel.get()).doubleValue(), ((Double)DoubleIntervalField.this.maximumValueModel.get()).doubleValue()));
                }
                validationModel.set((Object)validationResult);
            }
        };
        this.minimumValidationModel.addChangeListener(validationListener);
        this.maximumValidationModel.addChangeListener(validationListener);
        model.addChangeListener(new IChangeableObjectListener(){

            public void objectChanged() {
                logger.log(ILevel.DEBUG, MessageFormat.format("model changed: {0}", model.get()));
                DoubleIntervalField.this.minimumValueModel.set(model.get() == null ? null : Double.valueOf(((DoubleInterval)model.get()).getMinimum()));
                DoubleIntervalField.this.maximumValueModel.set(model.get() == null ? null : Double.valueOf(((DoubleInterval)model.get()).getMaximum()));
            }
        });
        this.minimumValueModel.addChangeListener(new IChangeableObjectListener(){

            public void objectChanged() {
                logger.log(ILevel.DEBUG, MessageFormat.format("minimum model changed: {0}", DoubleIntervalField.this.minimumValueModel.get()));
                IValidationResult validationResult = DoubleIntervalField.this.checkValid();
                if (validationResult.isValid()) {
                    model.set(DoubleIntervalField.this.minimumValueModel.get() == null && DoubleIntervalField.this.maximumValueModel.get() == null ? null : new DoubleInterval(((Double)DoubleIntervalField.this.minimumValueModel.get()).doubleValue(), ((Double)DoubleIntervalField.this.maximumValueModel.get()).doubleValue()));
                }
                validationModel.set((Object)validationResult);
            }
        });
        this.maximumValueModel.addChangeListener(new IChangeableObjectListener(){

            public void objectChanged() {
                logger.log(ILevel.DEBUG, MessageFormat.format("maximum model changed: {0}", DoubleIntervalField.this.maximumValueModel.get()));
                IValidationResult validationResult = DoubleIntervalField.this.checkValid();
                if (validationResult.isValid()) {
                    model.set(DoubleIntervalField.this.minimumValueModel.get() == null && DoubleIntervalField.this.maximumValueModel.get() == null ? null : new DoubleInterval(((Double)DoubleIntervalField.this.minimumValueModel.get()).doubleValue(), ((Double)DoubleIntervalField.this.maximumValueModel.get()).doubleValue()));
                }
                validationModel.set((Object)validationResult);
            }
        });
    }

    protected IValidationResult checkValid() {
        if (this.minimumValueModel.get() == null && this.maximumValueModel.get() == null || this.minimumValueModel.get() != null && this.maximumValueModel.get() != null && (Double)this.minimumValueModel.get() < (Double)this.maximumValueModel.get()) {
            return IValidationResult.valid();
        }
        if (this.minimumValueModel.get() == null) {
            return IValidationResult.inValid((String)ObjectFieldMessages.MissingMinimumValue);
        }
        if (this.maximumValueModel.get() == null) {
            return IValidationResult.inValid((String)ObjectFieldMessages.MissingMaximumValue);
        }
        if (((Double)this.maximumValueModel.get()).doubleValue() == ((Double)this.minimumValueModel.get()).doubleValue()) {
            return IValidationResult.inValid((String)ObjectFieldMessages.MinimumValueEqualsMaximumValue);
        }
        return IValidationResult.inValid((String)ObjectFieldMessages.MinimumValueIsLargerThanMaximumValue);
    }

    @Override
    public JComponent getComponent() {
        if (this.component == null) {
            this.component = this.createComponent();
        }
        return this.component;
    }

    private JPanel createComponent() {
        ValueValidator validator = new ValueValidator(this.minimum, this.maximum);
        final IObjectField<Double> minimumField = this.createDoubleField(this.minimumValueModel, this.minimumValidationModel, validator);
        IObjectField<Double> maximumField = this.createDoubleField(this.maximumValueModel, this.maximumValidationModel, validator);
        JPanel panel = new JPanel(new SpringLayout()){

            @Override
            public void requestFocus() {
                minimumField.getComponent().requestFocus();
            }
        };
        panel.add(minimumField.getComponent());
        panel.add(maximumField.getComponent());
        SpringLayoutUtilities.makeCompactGrid(panel, 2, 1, 0, 0, 6, 0);
        return panel;
    }

    private IObjectField<Double> createDoubleField(IObjectModel<Double> valueModel, IObjectModel<IValidationResult> validationModel, ValueValidator validator) {
        DoubleFieldBuilder builder = (DoubleFieldBuilder)((DoubleFieldBuilder)((DoubleFieldBuilder)((DoubleFieldBuilder)new DoubleFieldBuilder().setModel(valueModel)).setValidStateModel(validationModel)).setValidator(validator)).setToStringConverter(this.toStringFormater);
        If.isTrue((boolean)Double.isFinite(this.stepSize)).excecute(() -> builder.addSpinnerActions(Double.isFinite(this.minimum) ? this.minimum : Double.NEGATIVE_INFINITY, Double.isFinite(this.maximum) ? this.maximum : Double.POSITIVE_INFINITY, this.stepSize));
        return builder.build();
    }

    @Override
    public IObjectModel<DoubleInterval> getModel() {
        return this.model;
    }

    @Override
    public IObjectDistributor<IValidationResult> getValidationResultDistributor() {
        return this.validationResultModel;
    }

    public static final class ValueValidator
    implements IValidator<String> {
        private final double minimum;
        private final double maximum;
        StringToDoubleConverter converter = new StringToDoubleConverter();

        public ValueValidator(double minimum, double maximum) {
            this.minimum = minimum;
            this.maximum = maximum;
        }

        public IValidationResult validate(String string) {
            try {
                boolean isInBoundery;
                Double valueObject = this.converter.convert(string);
                if (valueObject == null) {
                    return IValidationResult.valid();
                }
                double value = valueObject;
                boolean bl = Double.isNaN(this.minimum) ? (Double.isNaN(this.maximum) ? true : value <= this.maximum) : (Double.isNaN(this.maximum) ? this.minimum <= value : (isInBoundery = this.minimum <= value && value <= this.maximum));
                if (isInBoundery) {
                    return IValidationResult.valid();
                }
                return IValidationResult.inValid((String)MessageFormat.format(ObjectFieldMessages.ValueIsOutOfBounderies_0_1, this.toString(this.minimum), this.toString(this.maximum)));
            }
            catch (NumberFormatException exception) {
                return IValidationResult.inValid((String)exception.getLocalizedMessage());
            }
        }

        private String toString(double value) {
            if (Double.isNaN(value)) {
                return ObjectFieldMessages.none;
            }
            return String.valueOf(value);
        }
    }
}

