/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.statebar;

import java.io.Serializable;
import java.util.Comparator;
import javax.swing.BorderFactory;
import net.anwiba.commons.swing.statebar.IStateBarComponentRegistry;
import net.anwiba.commons.swing.statebar.StateBar;
import net.anwiba.commons.swing.statebar.StateBarComponentConfiguration;
import net.anwiba.commons.swing.statebar.StateBarComponentDescription;
import net.anwiba.commons.utilities.registry.KeyValueRegistry;

public class StateBarManager
implements IStateBarComponentRegistry {
    private final KeyValueRegistry<StateBarComponentDescription, StateBarComponentConfiguration> registry = new KeyValueRegistry();
    final Comparator<StateBarComponentDescription> comparator = new StateBarComponentDescriptionComparator();

    private void addComponent(StateBarComponentConfiguration stateBarComponentConfiguration) {
        this.registry.register((Object)stateBarComponentConfiguration.getStateBarComponentDescription(), (Object)stateBarComponentConfiguration);
    }

    @Override
    public void add(StateBarComponentConfiguration ... stateBarComponentConfigurations) {
        StateBarComponentConfiguration[] stateBarComponentConfigurationArray = stateBarComponentConfigurations;
        int n = stateBarComponentConfigurations.length;
        int n2 = 0;
        while (n2 < n) {
            StateBarComponentConfiguration stateBarComponentConfiguration = stateBarComponentConfigurationArray[n2];
            this.addComponent(stateBarComponentConfiguration);
            ++n2;
        }
    }

    public StateBar getStateBar() {
        StateBarComponentConfiguration[] stateBarComponentConfigurations = (StateBarComponentConfiguration[])this.registry.getItems(this.comparator, StateBarComponentDescription.class, StateBarComponentConfiguration.class);
        StateBar stateBar = new StateBar();
        stateBar.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        StateBarComponentConfiguration[] stateBarComponentConfigurationArray = stateBarComponentConfigurations;
        int n = stateBarComponentConfigurations.length;
        int n2 = 0;
        while (n2 < n) {
            StateBarComponentConfiguration stateBarComponentConfiguration = stateBarComponentConfigurationArray[n2];
            stateBar.add(stateBarComponentConfiguration.getStateBarComponentDescription().getSide(), stateBarComponentConfiguration.getStateBarComponent().getComponent());
            ++n2;
        }
        return stateBar;
    }

    public static final class StateBarComponentDescriptionComparator
    implements Comparator<StateBarComponentDescription>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(StateBarComponentDescription o1, StateBarComponentDescription o2) {
            return Integer.valueOf(o1.getWeight()).compareTo(o2.getWeight());
        }
    }
}

