/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.table;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.text.PlainDocument;
import net.anwiba.commons.lang.functional.IBlock;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.model.IChangeableObjectListener;
import net.anwiba.commons.model.IObjectModel;
import net.anwiba.commons.model.ObjectModel;
import net.anwiba.commons.swing.object.IKeyListenerFactory;
import net.anwiba.commons.swing.object.IObjectField;
import net.anwiba.commons.swing.object.StringFieldBuilder;
import net.anwiba.commons.swing.table.FilterableObjectTableModel;
import net.anwiba.commons.swing.table.IObjectListTableConfiguration;
import net.anwiba.commons.swing.table.IRowFilter;
import net.anwiba.commons.swing.table.ObjectListTableMessages;
import net.anwiba.commons.swing.table.ObjectListTableModel;
import net.anwiba.commons.swing.table.ObjectTable;
import net.anwiba.commons.swing.table.filter.ContainsFilter;
import net.anwiba.commons.swing.table.filter.IColumToStringConverter;
import net.anwiba.commons.utilities.string.StringUtilities;

public class ObjectListTable<T>
extends ObjectTable<T> {
    private final IObjectModel<IRowFilter> rowFilterModel;
    private final IObjectListTableConfiguration<T> configuration;

    public ObjectListTable(IObjectListTableConfiguration<T> configuration, List<T> list) {
        super(configuration, new FilterableObjectTableModel<T>(new ObjectListTableModel<T>(list, configuration.getColumnValueProviders(), configuration.getColumnValueAdaptors(), configuration.getColumnClassProvider())));
        this.configuration = configuration;
        final FilterableObjectTableModel tableModel = (FilterableObjectTableModel)this.getTableModel();
        ObjectModel rowFilterModel = new ObjectModel();
        rowFilterModel.addChangeListener(new IChangeableObjectListener((IObjectModel)rowFilterModel){
            private final /* synthetic */ IObjectModel val$rowFilterModel;
            {
                this.val$rowFilterModel = iObjectModel;
            }

            public void objectChanged() {
                tableModel.setRowFilter((IRowFilter)this.val$rowFilterModel.get());
            }
        });
        this.rowFilterModel = rowFilterModel;
        ((ObjectListTableModel)tableModel.getObjectTableModel()).setChangeable(!this.getSortStateModel().get());
        this.getSortStateModel().addChangeListener(new IChangeableObjectListener(){

            public void objectChanged() {
                ((ObjectListTableModel)tableModel.getObjectTableModel()).setChangeable(!ObjectListTable.this.getSortStateModel().get());
            }
        });
    }

    public IObjectModel<IRowFilter> getRowFilterModel() {
        return this.rowFilterModel;
    }

    @Override
    public JComponent getComponent() {
        if (this.configuration.isTextFieldEnable() || !this.configuration.getTextFieldActionConfiguration().isEmpty()) {
            StringFieldBuilder builder = (StringFieldBuilder)new StringFieldBuilder().addClearAction(ObjectListTableMessages.clear);
            this.configuration.getTextFieldActionConfiguration().getFactories().forEach(f -> {
                Object b = builder.addActionFactory((model, document, enabledDistributor, clearBlock) -> f.create(this.getTableModel(), this.getSelectionIndexModel(), this.getSelectionModel(), enabledDistributor, (IObjectModel<String>)model, (IBlock<RuntimeException>)clearBlock));
            });
            Optional.of(this.configuration.getTextFieldKeyListenerFactory()).consume(f -> {
                Object b = builder.setKeyListenerFactory(new IKeyListenerFactory<String>(){

                    @Override
                    public KeyListener create(IObjectModel<String> model, PlainDocument document, IBlock<RuntimeException> clearBlock) {
                        return f.create(ObjectListTable.this.getTableModel(), ObjectListTable.this.getSelectionIndexModel(), ObjectListTable.this.getSelectionModel(), model, clearBlock);
                    }
                });
            });
            IObjectField stringField = builder.build();
            IObjectModel model = stringField.getModel();
            if (this.configuration.isFilterable()) {
                IObjectModel<IRowFilter> rowFilterModel = this.getRowFilterModel();
                IColumToStringConverter filterToStringConverter = this.configuration.getRowFilterToStringConverter();
                model.addChangeListener(() -> {
                    String value = (String)model.get();
                    if (StringUtilities.isNullOrTrimmedEmpty((String)value)) {
                        rowFilterModel.set(null);
                        return;
                    }
                    rowFilterModel.set((Object)new ContainsFilter(value, filterToStringConverter));
                });
            }
            JPanel contentPane = new JPanel();
            contentPane.setLayout(new BorderLayout());
            contentPane.add((Component)stringField.getComponent(), "North");
            contentPane.add("Center", super.getComponent());
            return contentPane;
        }
        return super.getComponent();
    }
}

