/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.table;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.model.BooleanModel;
import net.anwiba.commons.model.IBooleanDistributor;
import net.anwiba.commons.model.ISelectionModel;
import net.anwiba.commons.model.SelectionModel;
import net.anwiba.commons.swing.component.IComponentProvider;
import net.anwiba.commons.swing.table.IColumnConfiguration;
import net.anwiba.commons.swing.table.IKeyListenerFactory;
import net.anwiba.commons.swing.table.IMouseListenerFactory;
import net.anwiba.commons.swing.table.IObjectTableConfiguration;
import net.anwiba.commons.swing.table.IObjectTableModel;
import net.anwiba.commons.swing.table.ISelectionIndexModel;
import net.anwiba.commons.swing.table.ObjectTableRowSorter;
import net.anwiba.commons.swing.table.SelectionIndexModel;
import net.anwiba.commons.swing.table.SortedRowMapper;
import net.anwiba.commons.swing.table.Table;
import net.anwiba.commons.swing.table.action.ITableActionFactory;
import net.anwiba.commons.swing.table.listener.SelectionListener;
import net.anwiba.commons.swing.table.listener.TableSelectionListener;
import net.anwiba.commons.swing.utilities.SpringLayoutUtilities;

public class ObjectTable<T>
implements IComponentProvider {
    private final SelectionModel<T> selectionModel = new SelectionModel();
    private final JComponent component;
    private final IObjectTableModel<T> tableModel;
    private final IBooleanDistributor sortStateModel;
    private ISelectionIndexModel<T> selectionIndexModel;

    public ObjectTable(IObjectTableConfiguration<T> configuration, IObjectTableModel<T> tableModel) {
        this.tableModel = tableModel;
        ObjectTableRowSorter<T> tableRowSorter = configuration.getRowSorter(tableModel);
        SortedRowMapper<T> sortedRowMapper = new SortedRowMapper<T>(tableRowSorter);
        Table table = new Table(tableModel);
        table.setRowSorter(tableRowSorter);
        table.setAutoResizeMode(configuration.getAutoResizeMode());
        table.setSelectionMode(configuration.getSelectionMode());
        table.setAutoCreateColumnsFromModel(false);
        table.setPreferredScrollableViewportSize(new Dimension(100, configuration.getPreferredVisibleRowCount() * (table.getRowHeight() + table.getRowMargin())));
        TableColumnModel columnModel = table.getColumnModel();
        int i = 0;
        while (i < columnModel.getColumnCount()) {
            this.applyToColumn(columnModel.getColumn(i), configuration.getColumnConfiguration(i));
            ++i;
        }
        ListSelectionModel tableSelectionModel = table.getSelectionModel();
        tableSelectionModel.addListSelectionListener(new TableSelectionListener<T>(tableModel, tableSelectionModel, this.selectionModel, sortedRowMapper));
        this.selectionModel.addSelectionListener(new SelectionListener<T>(tableModel, tableSelectionModel, this.selectionModel, sortedRowMapper));
        this.selectionIndexModel = new SelectionIndexModel<T>(tableSelectionModel, sortedRowMapper, this.selectionModel);
        this.sortStateModel = tableRowSorter == null ? new BooleanModel(false) : tableRowSorter.getSortStateModel();
        IMouseListenerFactory<T> mouseListenerFactory = configuration.getMouseListenerFactory();
        table.addMouseListener(mouseListenerFactory.create(tableModel, this.selectionIndexModel, this.getSelectionModel(), this.sortStateModel));
        IKeyListenerFactory<T> keyListenerFactory = configuration.getKeyListenerFactory();
        table.addKeyListener(keyListenerFactory.create(tableModel, this.selectionIndexModel, (ISelectionModel<T>)this.selectionModel, this.sortStateModel));
        if (configuration.getTableActionConfiguration().isEmpty()) {
            this.component = new JScrollPane(table);
            return;
        }
        Iterable<ITableActionFactory<T>> factories = configuration.getTableActionConfiguration().getFactories();
        JPanel buttonPanel = new JPanel(new SpringLayout());
        for (ITableActionFactory<T> factory : factories) {
            Optional.of((Object)factory.create(tableModel, this.selectionIndexModel, (ISelectionModel<T>)this.selectionModel, this.sortStateModel)).convert(a -> new JButton(factory.create(tableModel, this.selectionIndexModel, (ISelectionModel<T>)this.selectionModel, this.sortStateModel))).consume(b -> {
                Component component = buttonPanel.add((Component)b);
            });
        }
        SpringLayoutUtilities.makeCompactGrid(buttonPanel, 1, buttonPanel.getComponentCount(), 6, 6, 6, 6);
        this.component = new JPanel(new BorderLayout());
        this.component.add((Component)new JScrollPane(table), "Center");
        JPanel buttonPanelContainer = new JPanel(new BorderLayout());
        buttonPanelContainer.add((Component)buttonPanel, "North");
        this.component.add((Component)buttonPanelContainer, "East");
    }

    public IObjectTableModel<T> getTableModel() {
        return this.tableModel;
    }

    public IBooleanDistributor getSortStateModel() {
        return this.sortStateModel;
    }

    private void applyToColumn(TableColumn column, IColumnConfiguration configuration) {
        if (configuration == null) {
            return;
        }
        if (configuration.getCellEditor() != null) {
            column.setCellEditor(configuration.getCellEditor());
        }
        if (configuration.getCellRenderer() != null) {
            column.setCellRenderer(configuration.getCellRenderer());
        }
        if (configuration.getPreferredWidth() > 0) {
            column.setPreferredWidth(configuration.getPreferredWidth());
        }
        if (configuration.getHeaderValue() != null) {
            column.setHeaderValue(configuration.getHeaderValue());
        }
    }

    @Override
    public JComponent getComponent() {
        return this.component;
    }

    public ISelectionIndexModel<T> getSelectionIndexModel() {
        return this.selectionIndexModel;
    }

    public ISelectionModel<T> getSelectionModel() {
        return this.selectionModel;
    }
}

