/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.table;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import net.anwiba.commons.lang.comparable.ComparableComparator;
import net.anwiba.commons.lang.comparable.NumberComparator;
import net.anwiba.commons.lang.functional.IAggregator;
import net.anwiba.commons.lang.functional.IFunction;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.swing.list.ObjectUiCellRendererConfigurationBuilder;
import net.anwiba.commons.swing.table.IColumnObjectFactory;
import net.anwiba.commons.swing.table.IColumnValueAdaptor;
import net.anwiba.commons.swing.table.IColumnValueProvider;
import net.anwiba.commons.swing.table.IKeyListenerFactory;
import net.anwiba.commons.swing.table.IMouseListenerFactory;
import net.anwiba.commons.swing.table.IObjectListColumnConfiguration;
import net.anwiba.commons.swing.table.IObjectListTableConfiguration;
import net.anwiba.commons.swing.table.IObjectTableBuilder;
import net.anwiba.commons.swing.table.ObjectListColumnConfiguration;
import net.anwiba.commons.swing.table.ObjectListTable;
import net.anwiba.commons.swing.table.ObjectListTableConfigurationBuilder;
import net.anwiba.commons.swing.table.action.ITableActionFactory;
import net.anwiba.commons.swing.table.action.ITableCheckActionEnabledValidator;
import net.anwiba.commons.swing.table.action.ITableTextFieldActionFactory;
import net.anwiba.commons.swing.table.action.ITableTextFieldKeyListenerFactory;
import net.anwiba.commons.swing.table.filter.IColumToStringConverter;
import net.anwiba.commons.swing.table.renderer.BooleanRenderer;
import net.anwiba.commons.swing.table.renderer.LocalDateTimeTableCellRenderer;
import net.anwiba.commons.swing.table.renderer.NumberTableCellRenderer;
import net.anwiba.commons.swing.table.renderer.ObjectTableCellRenderer;
import net.anwiba.commons.swing.ui.ObjectUiBuilder;

public class ObjectTableBuilder<T>
implements IObjectTableBuilder<T> {
    final ObjectListTableConfigurationBuilder<T> builder = new ObjectListTableConfigurationBuilder();
    private final List<T> values = new ArrayList<T>();

    @Override
    public IObjectTableBuilder<T> setKeyListenerFactory(IKeyListenerFactory<T> keyListenerFactory) {
        this.builder.setKeyListenerFactory(keyListenerFactory);
        return this;
    }

    @Override
    public IObjectTableBuilder<T> setSelectionMode(int selectionMode) {
        this.builder.setSelectionMode(selectionMode);
        return this;
    }

    @Override
    public IObjectTableBuilder<T> addColumn(IObjectListColumnConfiguration<T> columnConfiguration) {
        this.builder.addColumnConfiguration(columnConfiguration);
        return this;
    }

    @Override
    public IObjectTableBuilder<T> addStringColumn(String title, final IFunction<T, String, RuntimeException> provider, int size) {
        this.builder.addColumnConfiguration(new ObjectListColumnConfiguration(title, new IColumnValueProvider<T>(){

            @Override
            public Object getValue(T object) {
                if (object == null) {
                    return null;
                }
                return provider.execute(object);
            }
        }, new ObjectTableCellRenderer(), size, String.class, true, null));
        return this;
    }

    @Override
    public IObjectTableBuilder<T> addSortableStringColumn(String title, final IFunction<T, String, RuntimeException> provider, int size) {
        this.builder.addColumnConfiguration(new ObjectListColumnConfiguration(title, new IColumnValueProvider<T>(){

            @Override
            public Object getValue(T object) {
                if (object == null) {
                    return null;
                }
                return provider.execute(object);
            }
        }, new ObjectTableCellRenderer(), size, String.class, true, null));
        return this;
    }

    @Override
    public IObjectTableBuilder<T> addEditableStringColumn(String title, final IFunction<T, String, RuntimeException> provider, final IAggregator<T, String, T, RuntimeException> adaptor, int size) {
        DefaultCellEditor cellEditor = new DefaultCellEditor(new JTextField());
        cellEditor.setClickCountToStart(2);
        this.builder.addColumnConfiguration(new ObjectListColumnConfiguration((Object)title, new IColumnValueProvider<T>(){

            @Override
            public Object getValue(T object) {
                if (object == null) {
                    return null;
                }
                return provider.execute(object);
            }
        }, new ObjectTableCellRenderer(), new IColumnValueAdaptor<T>(){

            @Override
            public T adapt(T object, Object value) {
                return adaptor.aggregate(object, (Object)((String)value));
            }
        }, cellEditor, size, false, null));
        return this;
    }

    @Override
    public IObjectTableBuilder<T> addSortableDoubleConfiguration(String title, final IFunction<T, Double, RuntimeException> provider, int size) {
        this.builder.addColumnConfiguration(new ObjectListColumnConfiguration(title, new IColumnValueProvider<T>(){

            @Override
            public Object getValue(T object) {
                if (object == null) {
                    return null;
                }
                return provider.execute(object);
            }
        }, new NumberTableCellRenderer("0.0000"), size, Double.class, true, (Comparator)new NumberComparator()));
        return this;
    }

    @Override
    public IObjectTableBuilder<T> addEditableIntegerColumn(String title, IFunction<T, Integer, RuntimeException> provider, IAggregator<T, Integer, T, RuntimeException> aggregator, JComponent component, int size) {
        DefaultCellEditor editor;
        if (component instanceof JComboBox) {
            JComboBox comboBox = (JComboBox)component;
            editor = new DefaultCellEditor(comboBox);
        } else if (component instanceof JTextField) {
            JTextField textField = (JTextField)component;
            editor = new DefaultCellEditor(textField);
        } else {
            throw new IllegalArgumentException("Unsupported component implementation");
        }
        this.builder.addColumnConfiguration(new ObjectListColumnConfiguration<Object>(title, object -> Optional.of((Object)object).convert(o -> (Integer)provider.execute(o)).get(), new ObjectUiCellRendererConfigurationBuilder().setHorizontalAlignmentRight().build(), new ObjectUiBuilder().text(v -> v.toString()).build(), (object, value) -> aggregator.aggregate(object, (Object)((Integer)value)), editor, size, Integer.class, false, null));
        return this;
    }

    @Override
    public IObjectTableBuilder<T> addIntegerColumn(String title, final IFunction<T, Integer, RuntimeException> provider, int size) {
        this.builder.addColumnConfiguration(new ObjectListColumnConfiguration(title, new IColumnValueProvider<T>(){

            @Override
            public Object getValue(T object) {
                if (object == null) {
                    return null;
                }
                return provider.execute(object);
            }
        }, new NumberTableCellRenderer("0"), size, Integer.class, false, (Comparator)new NumberComparator()));
        return this;
    }

    @Override
    public IObjectTableBuilder<T> addSortableIntegerColumn(String title, final IFunction<T, Integer, RuntimeException> provider, int size) {
        this.builder.addColumnConfiguration(new ObjectListColumnConfiguration(title, new IColumnValueProvider<T>(){

            @Override
            public Object getValue(T object) {
                if (object == null) {
                    return null;
                }
                return provider.execute(object);
            }
        }, new NumberTableCellRenderer("0"), size, Integer.class, true, (Comparator)new NumberComparator()));
        return this;
    }

    @Override
    public IObjectTableBuilder<T> addSortableLocalTimeDateColumn(String title, final IFunction<T, LocalDateTime, RuntimeException> provider, int size) {
        this.builder.addColumnConfiguration(new ObjectListColumnConfiguration(title, new IColumnValueProvider<T>(){

            @Override
            public Object getValue(T object) {
                if (object == null) {
                    return null;
                }
                return provider.execute(object);
            }
        }, new LocalDateTimeTableCellRenderer(), size, Double.class, true, (Comparator)new ComparableComparator()));
        return this;
    }

    @Override
    public IObjectTableBuilder<T> addSortableBooleanColumn(String title, final IFunction<T, Boolean, RuntimeException> provider, int size) {
        this.builder.addColumnConfiguration(new ObjectListColumnConfiguration(title, new IColumnValueProvider<T>(){

            @Override
            public Object getValue(T object) {
                if (object == null) {
                    return null;
                }
                return provider.execute(object);
            }
        }, new BooleanRenderer(), size, Boolean.class, true, null));
        return this;
    }

    @Override
    public IObjectTableBuilder<T> addActionFactory(ITableActionFactory<T> factory) {
        this.builder.addActionFactory(factory);
        return this;
    }

    @Override
    public IObjectTableBuilder<T> addActionFactory(ITableActionFactory<T> factory, ITableCheckActionEnabledValidator<T> validator) {
        this.builder.addActionFactory(factory, validator);
        return this;
    }

    @Override
    public IObjectTableBuilder<T> addTextFieldActionFactory(ITableTextFieldActionFactory<T> factory) {
        this.builder.addTextFieldActionFactory(factory);
        return this;
    }

    @Override
    public IObjectTableBuilder<T> setPreferredVisibleRowCount(int preferredVisibleRowCount) {
        this.builder.setPreferredVisibleRowCount(preferredVisibleRowCount);
        return this;
    }

    @Override
    public IObjectTableBuilder<T> setMouseListenerFactory(IMouseListenerFactory<T> mouseListenerFactory) {
        this.builder.setMouseListenerFactory(mouseListenerFactory);
        return this;
    }

    @Override
    public IObjectTableBuilder<T> addAddObjectAction(IColumnObjectFactory<T, T, RuntimeException> factory) {
        this.builder.addAddObjectAction(factory);
        return this;
    }

    @Override
    public IObjectTableBuilder<T> addEditObjectAction(IColumnObjectFactory<T, T, RuntimeException> factory) {
        this.builder.addEditObjectAction(factory);
        return this;
    }

    @Override
    public IObjectTableBuilder<T> addRemoveObjectsAction() {
        this.builder.addRemoveObjectsAction();
        return this;
    }

    @Override
    public IObjectTableBuilder<T> addMoveObjectUpAction() {
        this.builder.addMoveObjectUpAction();
        return this;
    }

    @Override
    public IObjectTableBuilder<T> addMoveObjectDownAction() {
        this.builder.addMoveObjectDownAction();
        return this;
    }

    @Override
    public IObjectTableBuilder<T> setFilterToStringConverter(IColumToStringConverter columnToStringConverter) {
        this.builder.setFilterToStringConverter(columnToStringConverter);
        return this;
    }

    @Override
    public IObjectTableBuilder<T> setValues(List<T> values) {
        this.values.clear();
        this.values.addAll(values);
        return this;
    }

    @Override
    public IObjectTableBuilder<T> addValue(T value) {
        this.values.add(value);
        return this;
    }

    @Override
    public ObjectListTable<T> build() {
        IObjectListTableConfiguration<T> configuration = this.builder.build();
        return new ObjectListTable<T>(configuration, this.values);
    }

    @Override
    public IObjectTableBuilder<T> setSingleSelectionMode() {
        this.builder.setSelectionMode(0);
        return this;
    }

    @Override
    public IObjectTableBuilder<T> setAutoResizeModeOff() {
        this.builder.setAutoResizeModeOff();
        return this;
    }

    @Override
    public IObjectTableBuilder<T> setTextFieldKeyListenerFactory(ITableTextFieldKeyListenerFactory<T> textFieldKeyListenerFactory) {
        this.builder.setTextFieldKeyListenerFactory(textFieldKeyListenerFactory);
        return this;
    }
}

