/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.ui;

import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import net.anwiba.commons.swing.ui.IObjectUi;
import net.anwiba.commons.swing.ui.IObjectUiCellRendererConfiguration;

public class ObjectUiListCellRenderer<T>
extends DefaultListCellRenderer {
    private final IObjectUi<T> objectUi;
    private final IObjectUiCellRendererConfiguration configuration;
    private static final long serialVersionUID = 1L;

    public ObjectUiListCellRenderer(IObjectUi<T> objectUi) {
        this(null, objectUi);
    }

    public ObjectUiListCellRenderer(IObjectUiCellRendererConfiguration configuration, IObjectUi<T> objectUi) {
        this.configuration = configuration;
        this.objectUi = objectUi;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        try {
            Object object = value;
            String text = this.objectUi.getText(object);
            Icon icon = this.objectUi.getIcon(object);
            this.setText(icon == null && (text == null || text.length() == 0) ? " " : text);
            this.setIcon(icon);
            this.setToolTipText(this.objectUi.getToolTipText(object));
            if (this.configuration == null) {
                return this;
            }
            this.setVerticalTextPosition(this.configuration.getVerticalTextPosition());
            this.setVerticalAlignment(this.configuration.getVerticalAlignment());
            this.setHorizontalTextPosition(this.configuration.getHorizontalTextPosition());
            this.setHorizontalAlignment(this.configuration.getHorizontalAlignment());
            this.setIconTextGap(this.configuration.getIconTextGap());
            this.setBorder(this.configuration.getBorder());
            return this;
        }
        catch (ClassCastException classCastException) {
            return this;
        }
    }
}

