/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.icon.demo;

import de.jdemo.annotation.Demo;
import de.jdemo.extensions.SwingDemoCase;
import de.jdemo.junit.DemoAsTestRunner;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import net.anwiba.commons.model.IChangeableObjectListener;
import net.anwiba.commons.swing.icon.MutableImageIcon;
import net.anwiba.commons.swing.icons.GuiIcons;
import org.junit.runner.RunWith;

@RunWith(value=DemoAsTestRunner.class)
public class MutableIconDemo
extends SwingDemoCase {
    @Demo
    public void simpleDemo() {
        MutableImageIcon icon = new MutableImageIcon(GuiIcons.MISC_ICON.getLargeIcon());
        this.show((Icon)icon);
    }

    @Demo
    public void complexDemo() {
        final MutableImageIcon icon = new MutableImageIcon(GuiIcons.MISC_ICON.getLargeIcon());
        final JLabel label = new JLabel((Icon)icon);
        icon.getModel().addChangeListener(new IChangeableObjectListener(){

            public void objectChanged() {
                label.repaint();
            }
        });
        this.show(label);
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(2000L);
                    icon.getModel().set((Object)GuiIcons.ADD_ICON.getLargeIcon());
                    Thread.sleep(2000L);
                    icon.getModel().set((Object)GuiIcons.CLOSE_ICON.getLargeIcon());
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        });
        thread.start();
    }

    @Demo
    public void complexDemoWithAction() {
        final MutableImageIcon icon = new MutableImageIcon(GuiIcons.MISC_ICON.getLargeIcon());
        AbstractAction action = new AbstractAction(null, (Icon)icon){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        final JButton button = new JButton(action);
        icon.getModel().addChangeListener(new IChangeableObjectListener(){

            public void objectChanged() {
                button.repaint();
            }
        });
        this.show(button);
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(2000L);
                    icon.getModel().set((Object)GuiIcons.ADD_ICON.getLargeIcon());
                    Thread.sleep(2000L);
                    icon.getModel().set((Object)GuiIcons.CLOSE_ICON.getLargeIcon());
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        });
        thread.start();
    }

    @Demo
    public void complexDemoWithActionAndNormalIcon() {
        final AbstractAction action = new AbstractAction(null, GuiIcons.MISC_ICON.getLargeIcon()){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        JButton button = new JButton(action);
        this.show(button);
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(2000L);
                    action.putValue("SmallIcon", GuiIcons.ADD_ICON.getLargeIcon());
                    Thread.sleep(2000L);
                    action.putValue("SmallIcon", GuiIcons.CLOSE_ICON.getLargeIcon());
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        });
        thread.start();
    }
}

