/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.combobox;

import java.util.List;
import net.anwiba.commons.model.IChangeableObjectListener;
import net.anwiba.commons.model.ObjectModel;
import net.anwiba.commons.swing.combobox.IComboBoxModel;
import net.anwiba.commons.swing.list.ObjectListComponentModel;

public class ObjectComboBoxComponentModel<T>
extends ObjectListComponentModel<T>
implements IComboBoxModel<T> {
    private final ObjectModel<T> model = new ObjectModel();
    private static final long serialVersionUID = 1L;

    public ObjectComboBoxComponentModel(List<T> objects) {
        super(objects);
        if (!objects.isEmpty()) {
            this.model.set(objects.get(0));
        }
        this.model.addChangeListener(new IChangeableObjectListener(){

            public void objectChanged() {
                ObjectComboBoxComponentModel.this.fireContentsChanged(ObjectComboBoxComponentModel.this, -1, -1);
            }
        });
    }

    @Override
    public void setSelectedItem(Object item) {
        this.model.set(item);
    }

    @Override
    public Object getSelectedItem() {
        return this.model.get();
    }

    public void addChangeListener(IChangeableObjectListener listener) {
        this.model.addChangeListener(listener);
    }

    public void removeChangeListener(IChangeableObjectListener listener) {
        this.model.removeChangeListener(listener);
    }

    public void removeChangeListeners() {
        this.model.removeChangeListeners();
    }

    public T get() {
        return (T)this.model.get();
    }

    public void set(T object) {
        this.model.set(object);
    }
}

