/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.dialog;

import java.awt.Window;
import javax.swing.Icon;
import net.anwiba.commons.message.ExceptionMessage;
import net.anwiba.commons.message.IMessage;
import net.anwiba.commons.message.Message;
import net.anwiba.commons.swing.dialog.DialogMessages;
import net.anwiba.commons.swing.dialog.DialogType;
import net.anwiba.commons.swing.dialog.IDialogResult;
import net.anwiba.commons.swing.dialog.MessageDialog;
import net.anwiba.commons.swing.dialog.MessageDialogLauncher;
import net.anwiba.commons.swing.dialog.exception.ExceptionDialog;
import net.anwiba.commons.swing.icons.GuiIcons;

public class MessageDialogUtilities {
    public static final IDialogResult show(Window owner, IMessage message) {
        return MessageDialogUtilities.show(owner, message.getText(), message);
    }

    public static final IDialogResult show(Window owner, String title, IMessage message) {
        return MessageDialogUtilities.show(owner, title, message, DialogType.CLOSE);
    }

    public static IDialogResult show(Window owner, String title, IMessage message, DialogType dialogType) {
        Icon icon = null;
        return MessageDialogUtilities.show(owner, title, message, icon, dialogType);
    }

    private static IDialogResult show(Window owner, String title, IMessage message, Icon icon, DialogType dialogType) {
        MessageDialog dialog = MessageDialogUtilities.create(owner, title, message, icon, dialogType);
        dialog.setVisible(true);
        return dialog.getResult();
    }

    public static IDialogResult showUnsupportedOperationDialog(Window owner) {
        return MessageDialogUtilities.show(owner, DialogMessages.ERROR, Message.create((String)"Unsupported operation", (String)"Not yet implemented"), GuiIcons.EMPTY_ICON.getLargeIcon(), DialogType.CLOSE);
    }

    private static MessageDialog create(Window owner, String title, IMessage message, Icon icon, DialogType dialogType) {
        if (message instanceof ExceptionMessage) {
            return new ExceptionDialog(owner, (ExceptionMessage)message);
        }
        return new MessageDialog(owner, title, message, icon, dialogType);
    }

    public static MessageDialogLauncher setTitle(String text) {
        MessageDialogLauncher launcher = new MessageDialogLauncher();
        return launcher.title(text);
    }
}

