/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.filechooser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Window;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import net.anwiba.commons.swing.preference.IWindowPreferences;
import net.anwiba.commons.swing.preference.WindowPrefereneceUpdatingListener;
import net.anwiba.commons.swing.utilities.ContainerUtilities;

public final class FileChooserDialog
extends JFileChooser {
    private static final long serialVersionUID = 1L;
    private final IWindowPreferences windowPreferences;

    public FileChooserDialog(IWindowPreferences windowPreferences) {
        this.windowPreferences = windowPreferences;
    }

    @Override
    protected JDialog createDialog(Component parent) throws HeadlessException {
        boolean supportsWindowDecorations;
        String title = this.getUI().getDialogTitle(this);
        this.putClientProperty("AccessibleDescription", title);
        Window window = ContainerUtilities.getParentWindow(parent);
        JDialog dialog = window instanceof Frame ? new JDialog((Frame)window, title, true) : new JDialog((Dialog)window, title, true);
        dialog.setComponentOrientation(this.getComponentOrientation());
        Container contentPane = dialog.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this, "Center");
        if (JDialog.isDefaultLookAndFeelDecorated() && (supportsWindowDecorations = UIManager.getLookAndFeel().getSupportsWindowDecorations())) {
            dialog.getRootPane().setWindowDecorationStyle(6);
        }
        WindowPrefereneceUpdatingListener updater = new WindowPrefereneceUpdatingListener(dialog, this.windowPreferences);
        if (this.windowPreferences.getBounds() == null) {
            dialog.pack();
            dialog.setLocationRelativeTo(parent);
            dialog.addComponentListener(updater);
            dialog.addWindowListener(updater);
            return dialog;
        }
        dialog.setBounds(this.windowPreferences.getBounds());
        dialog.addComponentListener(updater);
        dialog.addWindowListener(updater);
        return dialog;
    }
}

