/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.object;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import net.anwiba.commons.lang.functional.IBlock;
import net.anwiba.commons.lang.functional.ICharFilter;
import net.anwiba.commons.lang.functional.IConverter;
import net.anwiba.commons.lang.functional.IFactory;
import net.anwiba.commons.model.BooleanModel;
import net.anwiba.commons.model.IBooleanDistributor;
import net.anwiba.commons.model.IBooleanModel;
import net.anwiba.commons.model.IObjectModel;
import net.anwiba.commons.model.ObjectModel;
import net.anwiba.commons.swing.action.ConfigurableActionBuilder;
import net.anwiba.commons.swing.icon.IGuiIcon;
import net.anwiba.commons.swing.icons.GuiIcons;
import net.anwiba.commons.swing.object.DefaultObjectFieldConfiguration;
import net.anwiba.commons.swing.object.IActionFactory;
import net.anwiba.commons.swing.object.IButtonFactory;
import net.anwiba.commons.swing.object.IKeyListenerFactory;
import net.anwiba.commons.swing.object.IObjectFieldConfiguration;
import net.anwiba.commons.swing.object.IToolTipFactory;
import net.anwiba.commons.swing.utilities.GuiUtilities;
import net.anwiba.commons.utilities.string.StringUtilities;
import net.anwiba.commons.utilities.validation.AggregatingStringValidator;
import net.anwiba.commons.utilities.validation.AllwaysValidStringValidator;
import net.anwiba.commons.utilities.validation.IValidationResult;
import net.anwiba.commons.utilities.validation.IValidator;

public abstract class AbstractObjectFieldConfigurationBuilder<T, C extends AbstractObjectFieldConfigurationBuilder<T, C>> {
    private boolean isEditable = true;
    private boolean isDisguise = false;
    private int columns = 10;
    private final List<IFactory<IConverter<String, T, RuntimeException>, IValidator<String>, RuntimeException>> validatorFactories = new ArrayList<IFactory<IConverter<String, T, RuntimeException>, IValidator<String>, RuntimeException>>();
    private ICharFilter characterFilter = c -> true;
    private IConverter<String, T, RuntimeException> toObjectConverter;
    private IConverter<T, String, RuntimeException> toStringConverter;
    private IToolTipFactory toolTipFactory = new IToolTipFactory(){

        @Override
        public String create(IValidationResult validationResult, String text) {
            if (!validationResult.isValid()) {
                return validationResult.getMessage();
            }
            if (StringUtilities.isNullOrEmpty((String)text)) {
                return null;
            }
            return text;
        }
    };
    private IObjectModel<IValidationResult> validStateModel = new ObjectModel((Object)IValidationResult.valid());
    private IObjectModel<T> model = new ObjectModel();
    private final List<IActionFactory<T>> actionFactorys = new ArrayList<IActionFactory<T>>();
    private final List<IButtonFactory<T>> buttonFactorys = new ArrayList<IButtonFactory<T>>();
    private Color background;
    private IKeyListenerFactory<T> keyListenerFactory;
    private IBooleanModel enabledModel = new BooleanModel(true);

    public AbstractObjectFieldConfigurationBuilder(IValidator<String> validator, IConverter<String, T, RuntimeException> toObjectConverter, IConverter<T, String, RuntimeException> toStringConverter) {
        this.validatorFactories.add(c -> validator);
        this.toObjectConverter = toObjectConverter;
        this.toStringConverter = toStringConverter;
    }

    public IObjectFieldConfiguration<T> build() {
        AllwaysValidStringValidator validator = this.validatorFactories.isEmpty() ? new AllwaysValidStringValidator() : (this.validatorFactories.size() == 1 ? (IValidator)this.validatorFactories.get(0).create(this.toObjectConverter) : new AggregatingStringValidator(this.validatorFactories.stream().map(f -> (IValidator)f.create(this.toObjectConverter)).collect(Collectors.toList())));
        return new DefaultObjectFieldConfiguration<T>(this.model, this.validStateModel, (IValidator<String>)validator, this.characterFilter, this.toObjectConverter, this.toStringConverter, this.toolTipFactory, this.enabledModel, this.isEditable, this.columns, this.actionFactorys, this.buttonFactorys, this.keyListenerFactory, this.background, this.isDisguise);
    }

    public void setDisguise(boolean isDisguise) {
        this.isDisguise = isDisguise;
    }

    public C setCharacterFilter(ICharFilter characterFilter) {
        this.characterFilter = characterFilter;
        return (C)this;
    }

    public C setKeyListenerFactory(IKeyListenerFactory<T> keyListenerFactory) {
        this.keyListenerFactory = keyListenerFactory;
        return (C)this;
    }

    public C setToolTipFactory(IToolTipFactory factory) {
        this.toolTipFactory = factory;
        return (C)this;
    }

    public C setModel(IObjectModel<T> model) {
        this.model = model;
        return (C)this;
    }

    public C setValidStateModel(IObjectModel<IValidationResult> validStateModel) {
        this.validStateModel = validStateModel;
        return (C)this;
    }

    public C setValidator(IValidator<String> validator) {
        this.validatorFactories.clear();
        this.validatorFactories.add(c -> validator);
        return (C)this;
    }

    public C addValidator(IValidator<String> validator) {
        this.validatorFactories.add(c -> validator);
        return (C)this;
    }

    public C setEnabledModel(IBooleanModel enabledModel) {
        this.enabledModel = enabledModel;
        return (C)this;
    }

    public C addValidatorFactory(IFactory<IConverter<String, T, RuntimeException>, IValidator<String>, RuntimeException> factory) {
        this.validatorFactories.add(factory);
        return (C)this;
    }

    public C setToObjectConverter(IConverter<String, T, RuntimeException> toObjectConverter) {
        this.toObjectConverter = toObjectConverter;
        return (C)this;
    }

    public C setToStringConverter(IConverter<T, String, RuntimeException> toStringConverter) {
        this.toStringConverter = toStringConverter;
        return (C)this;
    }

    public C setEditable(boolean isEditable) {
        this.isEditable = isEditable;
        return (C)this;
    }

    public C setColumns(int columns) {
        this.columns = columns;
        return (C)this;
    }

    public C addActionFactory(IActionFactory<T> actionFactory) {
        this.actionFactorys.add(actionFactory);
        return (C)this;
    }

    public C addButtonFactory(IButtonFactory<T> actionFactory) {
        this.buttonFactorys.add(actionFactory);
        return (C)this;
    }

    public C setBackgroundColor(Color background) {
        this.background = background;
        return (C)this;
    }

    public C addClearAction(final String tooltip) {
        this.addActionFactory(new IActionFactory<T>(){

            @Override
            public AbstractAction create(IObjectModel<T> context, final Document document, final IBooleanDistributor enabledDistributor, IBlock<RuntimeException> clearBlock) throws RuntimeException {
                ConfigurableActionBuilder builder = new ConfigurableActionBuilder();
                final AbstractAction action = builder.setIcon((IGuiIcon)GuiIcons.EDIT_CLEAR_LOCATIONBAR_ICON).setTooltip(tooltip).setProcedure(value -> clearBlock.execute()).build();
                this.setEnabled(document, enabledDistributor, action);
                enabledDistributor.addChangeListener(() -> this.setEnabled(document, enabledDistributor, action));
                document.addDocumentListener(new DocumentListener(){

                    @Override
                    public void removeUpdate(DocumentEvent e) {
                        this.setEnabled(document, enabledDistributor, action);
                    }

                    @Override
                    public void insertUpdate(DocumentEvent e) {
                        this.setEnabled(document, enabledDistributor, action);
                    }

                    @Override
                    public void changedUpdate(DocumentEvent e) {
                        this.setEnabled(document, enabledDistributor, action);
                    }
                });
                return action;
            }

            public void setEnabled(Document document, IBooleanDistributor enabledDistributor, AbstractAction action) {
                GuiUtilities.invokeLater(() -> action.setEnabled(document.getLength() != 0 && enabledDistributor.get()));
            }
        });
        return (C)this;
    }
}

