/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.object;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.ToolTipManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.metal.MetalBorders;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import net.anwiba.commons.lang.functional.IBlock;
import net.anwiba.commons.lang.functional.ICharFilter;
import net.anwiba.commons.lang.functional.IConverter;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.model.IBooleanDistributor;
import net.anwiba.commons.model.IBooleanModel;
import net.anwiba.commons.model.IChangeableObjectListener;
import net.anwiba.commons.model.IObjectDistributor;
import net.anwiba.commons.model.IObjectModel;
import net.anwiba.commons.swing.object.FieldValueController;
import net.anwiba.commons.swing.object.IActionFactory;
import net.anwiba.commons.swing.object.IActionNotifier;
import net.anwiba.commons.swing.object.IButtonFactory;
import net.anwiba.commons.swing.object.IColorReciever;
import net.anwiba.commons.swing.object.IKeyListenerFactory;
import net.anwiba.commons.swing.object.IObjectFieldConfiguration;
import net.anwiba.commons.swing.object.IObjectTextField;
import net.anwiba.commons.swing.object.IToolTipFactory;
import net.anwiba.commons.swing.utilities.JTextComponentUtilities;
import net.anwiba.commons.utilities.validation.IValidationResult;
import net.anwiba.commons.utilities.validation.IValidator;

public abstract class AbstractObjectTextField<T>
implements IObjectTextField<T> {
    static ILogger logger = Logging.getLogger((String)AbstractObjectTextField.class.getName());
    private final IObjectModel<T> model;
    private final IObjectModel<IValidationResult> validStateModel;
    private final JTextField textField;
    private final JComponent component;
    private final IValidator<String> validator;
    private final IConverter<String, T, RuntimeException> toObjectConverter;
    private final IConverter<T, String, RuntimeException> toStringConverter;
    private final ICharFilter characterFilter;
    private final IActionNotifier actionNotifier;
    private FieldValueController<T> controller;

    public AbstractObjectTextField(IObjectFieldConfiguration<T> configuration) {
        this.model = configuration.getModel();
        this.validStateModel = configuration.getValidationResultModel();
        this.validator = configuration.getValidator();
        this.toObjectConverter = configuration.getToObjectConverter();
        this.toStringConverter = configuration.getToStringConverter();
        this.characterFilter = configuration.getCharacterFilter();
        PlainDocument document = new PlainDocument();
        final JTextField field = configuration.isDisguise() ? new PasswordField<T>(document, configuration, (IObjectDistributor<IValidationResult>)this.validStateModel) : new TextField<T>(document, configuration, (IObjectDistributor<IValidationResult>)this.validStateModel);
        IKeyListenerFactory<T> keyListenerFactory = configuration.getKeyListenerFactory();
        IBlock clearBlock = () -> {
            if (document.getLength() == 0) {
                return;
            }
            if (!((IValidationResult)this.validStateModel.get()).isValid()) {
                try {
                    document.remove(0, document.getLength());
                }
                catch (BadLocationException badLocationException) {}
                return;
            }
            this.model.set(null);
        };
        if (keyListenerFactory != null) {
            field.addKeyListener(keyListenerFactory.create(this.model, document, (IBlock<RuntimeException>)clearBlock));
        }
        IBooleanModel enabledModel = configuration.getEnabledModel();
        field.setEnabled(enabledModel.get());
        enabledModel.addChangeListener(() -> field.setEnabled(enabledModel.get()));
        this.textField = field;
        Collection<IActionFactory<T>> actionFactorys = configuration.getActionFactorys();
        Collection<IButtonFactory<T>> buttonFactorys = configuration.getButtonFactorys();
        if (configuration.getBackgroundColor() != null) {
            this.textField.setBackground(configuration.getBackgroundColor());
        }
        if (actionFactorys.isEmpty() && buttonFactorys.isEmpty()) {
            this.component = field;
        } else {
            MetalBorders.TextFieldBorder border = new MetalBorders.TextFieldBorder();
            field.getBorder();
            this.component = new JPanel(new BorderLayout());
            this.component.setBackground(field.getBackground());
            this.component.setBorder(new MetalBorders.TextFieldBorder());
            field.setBorder(BorderFactory.createEmptyBorder());
            this.component.add((Component)field, "Center");
            JPanel actionContainer = new JPanel();
            actionContainer.setBackground(field.getBackground());
            actionContainer.setBorder(BorderFactory.createEmptyBorder());
            int width = 0;
            int height = 0;
            for (IActionFactory<T> iActionFactory : actionFactorys) {
                Action action = iActionFactory.create(this.model, document, (IBooleanDistributor)enabledModel, (IBlock<RuntimeException>)clearBlock);
                JButton button = new JButton(action);
                button.setBackground(field.getBackground());
                button.setBorder(BorderFactory.createEmptyBorder());
                width += button.getMinimumSize().width;
                height = Math.max(height, button.getMinimumSize().height);
                actionContainer.add(button);
            }
            for (IButtonFactory iButtonFactory : buttonFactorys) {
                AbstractButton button = iButtonFactory.create(this.model, document, (IBooleanDistributor)enabledModel, (IBlock<RuntimeException>)clearBlock);
                button.setBackground(field.getBackground());
                button.setBorder(BorderFactory.createEmptyBorder());
                width += button.getMinimumSize().width;
                height = Math.max(height, button.getMinimumSize().height);
                actionContainer.add(button);
            }
            actionContainer.setMinimumSize(new Dimension(width, height));
            actionContainer.setMaximumSize(new Dimension(width, height));
            this.component.add((Component)actionContainer, "East");
            Insets insets = border.getBorderInsets(this.component);
            int componentHeight = insets.top + insets.bottom + height;
            this.component.setMinimumSize(new Dimension(field.getMinimumSize().width + width, componentHeight));
            this.component.setPreferredSize(new Dimension(field.getPreferredSize().width + width, componentHeight + 10));
            this.component.setMaximumSize(new Dimension(Integer.MAX_VALUE, componentHeight + 10));
        }
        this.textField.setEditable(configuration.isEditable());
        this.actionNotifier = new IActionNotifier(){

            @Override
            public void removeActionListener(ActionListener listener) {
                field.removeActionListener(listener);
            }

            @Override
            public void addActionListener(ActionListener listener) {
                field.addActionListener(listener);
            }
        };
        final FieldValueController<T> valuesController = new FieldValueController<T>(document, this.model, () -> this.textField.isEditable(), this.toObjectConverter, this.toStringConverter, this.validStateModel, this.characterFilter, this.validator);
        this.controller = valuesController;
        document.addDocumentListener(new DocumentListener(){

            private void documentChanged() {
                valuesController.documentChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.documentChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.documentChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.documentChanged();
            }
        });
        this.model.addChangeListener(new IChangeableObjectListener(){

            public void objectChanged() {
                AbstractObjectTextField.this.controller.modelChanged();
            }
        });
        this.textField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent event) {
                char character = event.getKeyChar();
                if (character == '\u001b' || character == '\u0003') {
                    valuesController.modelChanged();
                    return;
                }
                if (character == '\b' || character == '\u007f' || character == '\uffcd' || character == '\uffcf' || character == '\n' || character == '&' || character == '(' || character == '\'' || character == '%' || character == '(' || character == '\u0011' || character == '\u009d' || character == '\u0012' || character == '\uff7e' || character == '\u020d' || character == '\"' || character == '!' || character == '\u009a' || character == '\u0014' || character == '\u0190' || character == '\u0192') {
                    return;
                }
                if (!AbstractObjectTextField.this.characterFilter.accept(character)) {
                    event.consume();
                }
            }

            @Override
            public void keyReleased(KeyEvent event) {
            }

            @Override
            public void keyPressed(KeyEvent event) {
            }
        });
        field.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                valuesController.format();
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        valuesController.modelChanged();
        this.validStateModel.set((Object)this.validator.validate((Object)this.getText()));
    }

    @Override
    public IObjectModel<T> getModel() {
        return this.model;
    }

    public void setHorizontalAlignment(int alignment) {
        this.textField.setHorizontalAlignment(alignment);
    }

    @Override
    public JComponent getComponent() {
        return this.component;
    }

    @Override
    public IObjectDistributor<IValidationResult> getValidationResultDistributor() {
        return this.validStateModel;
    }

    @Override
    public void setEditable(boolean isEditable) {
        this.textField.setEditable(isEditable);
    }

    @Override
    public void setText(String text) {
        this.controller.setText(text);
    }

    @Override
    public String getText() {
        return this.controller.getText();
    }

    public IActionNotifier getActionNotifier() {
        return this.actionNotifier;
    }

    public void selectAll() {
        this.textField.selectAll();
    }

    public IColorReciever getColorReciever() {
        return new IColorReciever(){

            @Override
            public void setForeground(Color color) {
                AbstractObjectTextField.this.textField.setForeground(color);
            }

            @Override
            public void setBackground(Color color) {
                AbstractObjectTextField.this.textField.setBackground(color);
            }
        };
    }

    public static final class PasswordField<T>
    extends JPasswordField {
        private final IObjectFieldConfiguration<T> configuration;
        private boolean isInititalized = false;
        private final IObjectDistributor<IValidationResult> validationResult;

        public PasswordField(PlainDocument document, IObjectFieldConfiguration<T> configuration, IObjectDistributor<IValidationResult> validationResult) {
            super(document, null, configuration.getColumns());
            this.validationResult = validationResult;
            this.isInititalized = true;
            this.configuration = configuration;
            ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
            if (configuration.getToolTipFactory() != null) {
                toolTipManager.registerComponent(this);
            }
        }

        @Override
        public void setDocument(Document doc) {
            if (this.isInititalized) {
                throw new UnsupportedOperationException();
            }
            if (doc instanceof PlainDocument) {
                super.setDocument(doc);
                return;
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public PlainDocument getDocument() {
            return (PlainDocument)super.getDocument();
        }

        @Override
        public void setToolTipText(String text) {
            super.setToolTipText(text);
            ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
            if (text == null && this.configuration.getToolTipFactory() != null) {
                toolTipManager.registerComponent(this);
            }
        }

        @Override
        public String getToolTipText() {
            IToolTipFactory toolTipFactory = this.configuration.getToolTipFactory();
            if (toolTipFactory == null) {
                return super.getToolTipText();
            }
            String value = this.getText();
            int columnWidth = this.getWidth();
            double valueWidth = JTextComponentUtilities.getValueWidth(this, value);
            if (valueWidth > (double)(columnWidth - 2)) {
                return toolTipFactory.create((IValidationResult)this.validationResult.get(), value);
            }
            return toolTipFactory.create((IValidationResult)this.validationResult.get(), null);
        }
    }

    public static final class TextField<T>
    extends JTextField {
        private final IObjectFieldConfiguration<T> configuration;
        private boolean isInititalized = false;
        private final IObjectDistributor<IValidationResult> validationResult;

        public TextField(PlainDocument document, IObjectFieldConfiguration<T> configuration, IObjectDistributor<IValidationResult> validationResult) {
            super(document, null, configuration.getColumns());
            this.validationResult = validationResult;
            this.isInititalized = true;
            this.configuration = configuration;
            ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
            if (configuration.getToolTipFactory() != null) {
                toolTipManager.registerComponent(this);
            }
        }

        @Override
        public void setDocument(Document doc) {
            if (this.isInititalized) {
                throw new UnsupportedOperationException();
            }
            if (doc instanceof PlainDocument) {
                super.setDocument(doc);
                return;
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public PlainDocument getDocument() {
            return (PlainDocument)super.getDocument();
        }

        @Override
        public void setToolTipText(String text) {
            super.setToolTipText(text);
            ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
            if (text == null && this.configuration.getToolTipFactory() != null) {
                toolTipManager.registerComponent(this);
            }
        }

        @Override
        public String getToolTipText() {
            IToolTipFactory toolTipFactory = this.configuration.getToolTipFactory();
            if (toolTipFactory == null) {
                return super.getToolTipText();
            }
            String value = this.getText();
            int columnWidth = this.getWidth();
            double valueWidth = JTextComponentUtilities.getValueWidth(this, value);
            if (valueWidth > (double)(columnWidth - 2)) {
                return toolTipFactory.create((IValidationResult)this.validationResult.get(), value);
            }
            return toolTipFactory.create((IValidationResult)this.validationResult.get(), null);
        }
    }
}

