/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.table.AbstractTableModel;
import net.anwiba.commons.lang.collection.IObjectIterable;
import net.anwiba.commons.lang.collection.IObjectIterator;
import net.anwiba.commons.lang.collection.ObjectList;
import net.anwiba.commons.model.IChangeableListListener;
import net.anwiba.commons.swing.table.IColumnClassProvider;
import net.anwiba.commons.swing.table.IObjectTableModel;
import net.anwiba.commons.utilities.ArrayUtilities;
import net.anwiba.commons.utilities.collection.IterableUtilities;
import net.anwiba.commons.utilities.interval.IntegerInterval;

public abstract class AbstractObjectTableModel<T>
extends AbstractTableModel
implements IObjectTableModel<T> {
    private static final long serialVersionUID = -9054338041837561007L;
    private final Map<T, Set<Integer>> indexByObjectMap = new HashMap<T, Set<Integer>>();
    private final List<T> objects = new ArrayList<T>();
    private final IColumnClassProvider columnClassProvider;
    private final List<IChangeableListListener<T>> listModelListeners = new ArrayList<IChangeableListListener<T>>();

    public AbstractObjectTableModel(List<T> objects, IColumnClassProvider columnClassProvider) {
        this.columnClassProvider = columnClassProvider;
        this.objects.addAll(objects);
        this.refreshIndex();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.columnClassProvider.getClass(columnIndex);
    }

    @Override
    public final String getColumnName(int columnIndex) {
        return "Column" + columnIndex;
    }

    public int size() {
        return this.getRowCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshIndex() {
        AbstractObjectTableModel abstractObjectTableModel = this;
        synchronized (abstractObjectTableModel) {
            this.indexByObjectMap.clear();
            int i = 0;
            while (i < this.objects.size()) {
                if (!this.indexByObjectMap.containsKey(this.get(i))) {
                    this.indexByObjectMap.put(this.get(i), new HashSet());
                }
                this.indexByObjectMap.get(this.get(i)).add(i);
                ++i;
            }
        }
    }

    public void set(T ... objects) {
        this.set((Iterable<T>)Arrays.asList(objects));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(Iterable<T> objects) {
        List oldObjects;
        AbstractObjectTableModel abstractObjectTableModel = this;
        synchronized (abstractObjectTableModel) {
            oldObjects = IterableUtilities.asList(this.objects);
            this.indexByObjectMap.clear();
            this.objects.clear();
            for (T object : objects) {
                if (!this.indexByObjectMap.containsKey(object)) {
                    this.indexByObjectMap.put(object, new HashSet());
                }
                Integer index = this.objects.size();
                this.indexByObjectMap.get(object).add(index);
                this.objects.add(object);
            }
        }
        this.fireTableDataChanged();
        this.fireObjectsChanged(oldObjects, IterableUtilities.asList(objects));
    }

    public void add(T ... objects) {
        this.add((Iterable<T>)Arrays.asList(objects));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Iterable<T> objects) {
        int rows;
        AbstractObjectTableModel abstractObjectTableModel = this;
        synchronized (abstractObjectTableModel) {
            rows = this.size();
            for (T object : objects) {
                if (!this.indexByObjectMap.containsKey(object)) {
                    this.indexByObjectMap.put(object, new HashSet());
                }
                Integer index = this.objects.size();
                this.indexByObjectMap.get(object).add(index);
                this.objects.add(object);
            }
        }
        this.fireTableRowsInserted(rows, this.size() - 1);
        this.fireObjectsAdded((Iterable<Integer>)new IntegerInterval(rows, this.size() - 1), objects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T set(int index, T object) {
        T oldObject;
        AbstractObjectTableModel abstractObjectTableModel = this;
        synchronized (abstractObjectTableModel) {
            if (index >= this.getRowCount()) {
                throw new IllegalArgumentException("index out of bounds");
            }
            if (!this.indexByObjectMap.containsKey(object)) {
                this.indexByObjectMap.put(object, new HashSet());
            }
            this.indexByObjectMap.get(object).add(this.objects.size());
            oldObject = this.objects.set(index, object);
        }
        this.fireTableRowsUpdated(index, index);
        this.fireObjectsUpdated(Arrays.asList(index), Arrays.asList(oldObject), Arrays.asList(object));
        return oldObject;
    }

    public synchronized int[] indices(Iterable<T> objects) {
        HashSet indexes = new HashSet();
        for (T object : objects) {
            HashSet objectIndexes = this.indexByObjectMap.get(object);
            indexes.addAll(objectIndexes == null ? new HashSet() : objectIndexes);
        }
        return ArrayUtilities.primitives((Integer[])indexes.toArray(new Integer[indexes.size()]));
    }

    public void remove(T ... objects) {
        int[] indices = this.indices(Arrays.asList(objects));
        this.remove(indices);
    }

    public void remove(Iterable<T> objects) {
        int[] indices = this.indices(objects);
        this.remove(indices);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int ... indices) {
        ArrayList<Integer> removedIndices = new ArrayList<Integer>();
        ArrayList<T> removedObjects = new ArrayList<T>();
        AbstractObjectTableModel abstractObjectTableModel = this;
        synchronized (abstractObjectTableModel) {
            if (indices.length == 0) {
                return;
            }
            Arrays.sort(indices);
            int i2 = indices.length - 1;
            while (i2 >= 0) {
                int index = indices[i2];
                T object = this.get(index);
                T removedObject = this.objects.remove(index);
                if (removedObject != null) {
                    Set<Integer> indizes = this.indexByObjectMap.get(removedObject);
                    if (indizes.remove(index) && indizes.isEmpty()) {
                        this.indexByObjectMap.remove(object);
                    }
                    removedIndices.add(index);
                    removedObjects.add(object);
                }
                --i2;
            }
        }
        removedIndices.forEach(i -> this.fireTableRowsDeleted((int)i, (int)i));
        this.fireObjectsRemoved(removedIndices, removedObjects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        ArrayList<T> objects;
        int rows;
        AbstractObjectTableModel abstractObjectTableModel = this;
        synchronized (abstractObjectTableModel) {
            rows = this.getRowCount();
            objects = new ArrayList<T>(this.objects);
            this.objects.clear();
            this.indexByObjectMap.clear();
        }
        this.fireTableRowsDeleted(0, rows - 1);
        this.fireObjectsRemoved((Iterable<Integer>)new IntegerInterval(0, rows - 1), objects);
    }

    public final IObjectIterable<T> values() {
        return new ObjectList(Collections.unmodifiableList(IterableUtilities.asList(this.objects)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        AbstractObjectTableModel abstractObjectTableModel = this;
        synchronized (abstractObjectTableModel) {
            return this.objects.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int getRowCount() {
        AbstractObjectTableModel abstractObjectTableModel = this;
        synchronized (abstractObjectTableModel) {
            return this.objects.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<T> get(int ... indices) {
        AbstractObjectTableModel abstractObjectTableModel = this;
        synchronized (abstractObjectTableModel) {
            ArrayList<T> result = new ArrayList<T>();
            int[] nArray = indices;
            int n = indices.length;
            int n2 = 0;
            while (n2 < n) {
                int index = nArray[n2];
                result.add(this.get(index));
                ++n2;
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(int rowIndex) {
        AbstractObjectTableModel abstractObjectTableModel = this;
        synchronized (abstractObjectTableModel) {
            block6: {
                block5: {
                    if (rowIndex >= 0) break block5;
                    return null;
                }
                if (rowIndex < this.objects.size()) break block6;
                return null;
            }
            return this.objects.get(rowIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<T> getObjects() {
        AbstractObjectTableModel abstractObjectTableModel = this;
        synchronized (abstractObjectTableModel) {
            LinkedList result = new LinkedList();
            this.objects.forEach(o -> {
                boolean bl = result.add(o);
            });
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<T> toCollection() {
        AbstractObjectTableModel abstractObjectTableModel = this;
        synchronized (abstractObjectTableModel) {
            return Collections.unmodifiableCollection(new ArrayList<T>(this.objects));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> toList() {
        AbstractObjectTableModel abstractObjectTableModel = this;
        synchronized (abstractObjectTableModel) {
            return Collections.unmodifiableList(new ArrayList<T>(this.objects));
        }
    }

    public IObjectIterator<T> iterator() {
        IObjectIterator iterator = this.values().iterator();
        return new IObjectIterator<T>((Iterator)iterator){
            private final /* synthetic */ Iterator val$iterator;
            {
                this.val$iterator = iterator;
            }

            public boolean hasNext() {
                return this.val$iterator.hasNext();
            }

            public T next() {
                return this.val$iterator.next();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addListModelListener(IChangeableListListener<T> listener) {
        List<IChangeableListListener<T>> list = this.listModelListeners;
        synchronized (list) {
            this.listModelListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeListModelListener(IChangeableListListener<T> listener) {
        List<IChangeableListListener<T>> list = this.listModelListeners;
        synchronized (list) {
            this.listModelListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireObjectsAdded(Iterable<Integer> indeces, Iterable<T> objects) {
        ArrayList<IChangeableListListener<T>> currentListModelListeners;
        List<IChangeableListListener<T>> list = this.listModelListeners;
        synchronized (list) {
            currentListModelListeners = new ArrayList<IChangeableListListener<T>>(this.listModelListeners);
        }
        for (IChangeableListListener iChangeableListListener : currentListModelListeners) {
            iChangeableListListener.objectsAdded(indeces, objects);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireObjectsChanged(List<T> oldObjects, List<T> newObjects) {
        ArrayList<IChangeableListListener<T>> currentListModelListeners;
        List<IChangeableListListener<T>> list = this.listModelListeners;
        synchronized (list) {
            currentListModelListeners = new ArrayList<IChangeableListListener<T>>(this.listModelListeners);
        }
        for (IChangeableListListener iChangeableListListener : currentListModelListeners) {
            iChangeableListListener.objectsChanged(oldObjects, newObjects);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireObjectsUpdated(Iterable<Integer> indeces, List<T> oldObjects, List<T> newObjects) {
        ArrayList<IChangeableListListener<T>> currentListModelListeners;
        List<IChangeableListListener<T>> list = this.listModelListeners;
        synchronized (list) {
            currentListModelListeners = new ArrayList<IChangeableListListener<T>>(this.listModelListeners);
        }
        for (IChangeableListListener iChangeableListListener : currentListModelListeners) {
            iChangeableListListener.objectsUpdated(indeces, oldObjects, newObjects);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireObjectsRemoved(Iterable<Integer> indeces, Iterable<T> objects) {
        ArrayList<IChangeableListListener<T>> currentListModelListeners;
        List<IChangeableListListener<T>> list = this.listModelListeners;
        synchronized (list) {
            currentListModelListeners = new ArrayList<IChangeableListListener<T>>(this.listModelListeners);
        }
        for (IChangeableListListener iChangeableListListener : currentListModelListeners) {
            iChangeableListListener.objectsRemoved(indeces, objects);
        }
    }
}

