/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.table;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import net.anwiba.commons.lang.primitive.IBooleanProvider;
import net.anwiba.commons.model.IBooleanDistributor;
import net.anwiba.commons.model.ISelectionModel;
import net.anwiba.commons.swing.table.IColumnObjectFactory;
import net.anwiba.commons.swing.table.IKeyListenerFactory;
import net.anwiba.commons.swing.table.IMouseListenerFactory;
import net.anwiba.commons.swing.table.IObjectListColumnConfiguration;
import net.anwiba.commons.swing.table.IObjectListTableConfiguration;
import net.anwiba.commons.swing.table.IObjectTableModel;
import net.anwiba.commons.swing.table.ISelectionIndexModel;
import net.anwiba.commons.swing.table.ObjectListTableConfiguration;
import net.anwiba.commons.swing.table.TableActionConfiguration;
import net.anwiba.commons.swing.table.TableTextFieldActionConfiguration;
import net.anwiba.commons.swing.table.action.AbstractTableActionFactory;
import net.anwiba.commons.swing.table.action.AddTableRowActionFactory;
import net.anwiba.commons.swing.table.action.EditTableActionFactory;
import net.anwiba.commons.swing.table.action.ITableActionClosure;
import net.anwiba.commons.swing.table.action.ITableActionFactory;
import net.anwiba.commons.swing.table.action.ITableCheckActionEnabledValidator;
import net.anwiba.commons.swing.table.action.ITableTextFieldActionFactory;
import net.anwiba.commons.swing.table.action.ITableTextFieldKeyListenerFactory;
import net.anwiba.commons.swing.table.action.MoveTableRowDownActionFactory;
import net.anwiba.commons.swing.table.action.MoveTableRowUpActionFactory;
import net.anwiba.commons.swing.table.action.RemoveTableRowActionFactory;
import net.anwiba.commons.swing.table.filter.IColumToStringConverter;
import net.anwiba.commons.utilities.string.IStringSubstituter;
import net.anwiba.commons.utilities.string.StringUtilities;

public class ObjectListTableConfigurationBuilder<T> {
    private int selectionMode = 2;
    private final List<IObjectListColumnConfiguration<T>> columnConfigurations = new ArrayList<IObjectListColumnConfiguration<T>>();
    private final List<ITableActionFactory<T>> actionFactories = new ArrayList<ITableActionFactory<T>>();
    private final List<ITableTextFieldActionFactory<T>> textFieldActionFactories = new ArrayList<ITableTextFieldActionFactory<T>>();
    private ITableTextFieldKeyListenerFactory<T> textFieldKeyListenerFactory;
    private int preferredVisibleRowCount = 10;
    private IMouseListenerFactory<T> tableMouseListenerFactory;
    private IKeyListenerFactory<T> keyListenerFactory;
    private IColumToStringConverter columnToStringConverter;
    private int autoRizeMode = -1;
    private IStringSubstituter toolTipSubstituter = s -> StringUtilities.substitute((String)s, (int)8, (int)120);
    private IMouseListenerFactory<T> headerMouseListenerFactory;

    public ObjectListTableConfigurationBuilder<T> setKeyListenerFactory(IKeyListenerFactory<T> keyListenerFactory) {
        this.keyListenerFactory = keyListenerFactory;
        return this;
    }

    public ObjectListTableConfigurationBuilder<T> setSelectionMode(int selectionMode) {
        this.selectionMode = selectionMode;
        return this;
    }

    public ObjectListTableConfigurationBuilder<T> addColumnConfiguration(IObjectListColumnConfiguration<T> columnConfiguration) {
        this.columnConfigurations.add(columnConfiguration);
        return this;
    }

    public ObjectListTableConfigurationBuilder<T> addActionFactory(ITableActionFactory<T> factory) {
        this.actionFactories.add(factory);
        return this;
    }

    public ObjectListTableConfigurationBuilder<T> addActionFactory(final ITableActionFactory<T> factory, final ITableCheckActionEnabledValidator<T> validator) {
        this.actionFactories.add(new AbstractTableActionFactory<T>(){

            @Override
            protected boolean checkEnabled(IObjectTableModel<T> tableModel, ISelectionIndexModel<T> selectionIndexModel, ISelectionModel<T> selectionModel, IBooleanProvider sortStateProvider) {
                return validator.checkEnabled(tableModel, selectionIndexModel, selectionModel, sortStateProvider);
            }

            @Override
            protected Action createAction(IObjectTableModel<T> tableModel, ISelectionIndexModel<T> selectionIndexModel, ISelectionModel<T> selectionModel, IBooleanDistributor sortStateProvider) {
                return factory.create(tableModel, selectionIndexModel, selectionModel, sortStateProvider);
            }
        });
        return this;
    }

    public ObjectListTableConfigurationBuilder<T> addTextFieldActionFactory(ITableTextFieldActionFactory<T> factory) {
        this.textFieldActionFactories.add(factory);
        return this;
    }

    public ObjectListTableConfigurationBuilder<T> setPreferredVisibleRowCount(int preferredVisibleRowCount) {
        this.preferredVisibleRowCount = preferredVisibleRowCount;
        return this;
    }

    public IObjectListTableConfiguration<T> build() {
        TableActionConfiguration<T> actionConfiguration = new TableActionConfiguration<T>(this.actionFactories);
        TableTextFieldActionConfiguration<T> textFieldActionConfiguration = new TableTextFieldActionConfiguration<T>(this.textFieldActionFactories);
        return new ObjectListTableConfiguration<T>(this.toolTipSubstituter, this.columnToStringConverter, this.autoRizeMode, this.selectionMode, this.preferredVisibleRowCount, this.columnConfigurations, this.headerMouseListenerFactory, this.tableMouseListenerFactory, this.keyListenerFactory, actionConfiguration, textFieldActionConfiguration, this.textFieldKeyListenerFactory);
    }

    public ObjectListTableConfigurationBuilder<T> setTableMouseListenerFactory(IMouseListenerFactory<T> mouseListenerFactory) {
        this.tableMouseListenerFactory = mouseListenerFactory;
        return this;
    }

    public ObjectListTableConfigurationBuilder<T> setHeaderMouseListenerFactory(IMouseListenerFactory<T> mouseListenerFactory) {
        this.headerMouseListenerFactory = mouseListenerFactory;
        return this;
    }

    public ObjectListTableConfigurationBuilder<T> addAddObjectAction(final IColumnObjectFactory<T, T, RuntimeException> factory) {
        return this.addActionFactory(new AddTableRowActionFactory(new ITableActionClosure<T>(){

            @Override
            public void execute(Component component, IObjectTableModel<T> tableModel, ISelectionIndexModel<T> selectionIndexModel) {
                Object current = this.getCurrentObject(tableModel, selectionIndexModel);
                Object object = factory.create(component, current);
                if (object == null) {
                    return;
                }
                tableModel.add(new Object[]{object});
                selectionIndexModel.set(tableModel.size() - 1);
            }

            private T getCurrentObject(IObjectTableModel<T> tableModel, ISelectionIndexModel<T> selectionIndexModel) {
                if (selectionIndexModel.size() != 1) {
                    return null;
                }
                int index = selectionIndexModel.getMinimum();
                return tableModel.get(index);
            }
        }));
    }

    public ObjectListTableConfigurationBuilder<T> addEditObjectAction(final IColumnObjectFactory<T, T, RuntimeException> factory) {
        return this.addActionFactory(new EditTableActionFactory(new ITableActionClosure<T>(){

            @Override
            public void execute(Component component, IObjectTableModel<T> tableModel, ISelectionIndexModel<T> selectionIndexModel) {
                if (selectionIndexModel.size() != 1) {
                    return;
                }
                int index = selectionIndexModel.getMinimum();
                Object current = tableModel.get(index);
                Object object = factory.create(component, current);
                tableModel.set(index, object);
                selectionIndexModel.set(index);
            }
        }));
    }

    public ObjectListTableConfigurationBuilder<T> addRemoveObjectsAction() {
        return this.addActionFactory(new RemoveTableRowActionFactory());
    }

    public ObjectListTableConfigurationBuilder<T> addMoveObjectUpAction() {
        return this.addActionFactory(new MoveTableRowUpActionFactory());
    }

    public ObjectListTableConfigurationBuilder<T> addMoveObjectDownAction() {
        return this.addActionFactory(new MoveTableRowDownActionFactory());
    }

    public ObjectListTableConfigurationBuilder<T> setFilterToStringConverter(IColumToStringConverter columnToStringConverter) {
        this.columnToStringConverter = columnToStringConverter;
        return this;
    }

    public ObjectListTableConfigurationBuilder<T> setAutoResizeModeOff() {
        this.autoRizeMode = 0;
        return this;
    }

    final ObjectListTableConfigurationBuilder<T> setToolTipSubstituter(IStringSubstituter stringSubstituter) {
        this.toolTipSubstituter = stringSubstituter;
        return this;
    }

    public ObjectListTableConfigurationBuilder<T> setTextFieldKeyListenerFactory(ITableTextFieldKeyListenerFactory<T> textFieldKeyListenerFactory) {
        this.textFieldKeyListenerFactory = textFieldKeyListenerFactory;
        return this;
    }
}

