/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.table;

import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.util.List;
import net.anwiba.commons.model.IBooleanDistributor;
import net.anwiba.commons.model.ISelectionModel;
import net.anwiba.commons.swing.table.IColumnConfiguration;
import net.anwiba.commons.swing.table.IKeyListenerFactory;
import net.anwiba.commons.swing.table.IMouseListenerFactory;
import net.anwiba.commons.swing.table.IObjectTableConfiguration;
import net.anwiba.commons.swing.table.IObjectTableModel;
import net.anwiba.commons.swing.table.ISelectionIndexModel;
import net.anwiba.commons.swing.table.ObjectTableRowSorter;
import net.anwiba.commons.swing.table.action.ITableActionConfiguration;
import net.anwiba.commons.utilities.string.IStringSubstituter;

public class ObjectTableConfiguration<T>
implements IObjectTableConfiguration<T> {
    private final List<? extends IColumnConfiguration> columnConfigurations;
    private final int selectionMode;
    private final ITableActionConfiguration<T> actionConfiguration;
    private final int preferredVisibleRowCount;
    private final IMouseListenerFactory<T> headerMouseListenerFactory;
    private final IMouseListenerFactory<T> tableMouseListenerFactory;
    private final IKeyListenerFactory<T> keyListenerFactory;
    private final int autoResizeMode;
    private final IStringSubstituter toolTipSubstituter;

    ObjectTableConfiguration(int autoizeMode, int selectionMode, int preferredVisibleRowCount, IStringSubstituter toolTipSubstituter, List<? extends IColumnConfiguration> columnConfigurations, IMouseListenerFactory<T> headerMouseListenerFactory, IMouseListenerFactory<T> tableMouseListenerFactory, IKeyListenerFactory<T> keyListenerFactory, ITableActionConfiguration<T> actionConfiguration) {
        this.autoResizeMode = autoizeMode;
        this.selectionMode = selectionMode;
        this.preferredVisibleRowCount = preferredVisibleRowCount;
        this.toolTipSubstituter = toolTipSubstituter;
        this.columnConfigurations = columnConfigurations;
        this.headerMouseListenerFactory = headerMouseListenerFactory;
        this.keyListenerFactory = keyListenerFactory == null ? new IKeyListenerFactory<T>(){

            @Override
            public KeyListener create(IObjectTableModel<T> tableModel, ISelectionIndexModel<T> selectionIndicesProvider, ISelectionModel<T> selectionModel, IBooleanDistributor sortStateModel) {
                return null;
            }
        } : keyListenerFactory;
        this.tableMouseListenerFactory = tableMouseListenerFactory == null ? new IMouseListenerFactory<T>(){

            @Override
            public MouseListener create(IObjectTableModel<T> tableModel, ISelectionIndexModel<T> selectionIndicesProvider, ISelectionModel<T> selectionModel, IBooleanDistributor sortStateModel) {
                return null;
            }
        } : tableMouseListenerFactory;
        this.actionConfiguration = actionConfiguration;
    }

    @Override
    public IColumnConfiguration getColumnConfiguration(int columnIndex) {
        if (columnIndex < 0 || this.columnConfigurations.size() <= columnIndex) {
            return null;
        }
        return this.columnConfigurations.get(columnIndex);
    }

    @Override
    public int getAutoResizeMode() {
        return this.autoResizeMode;
    }

    @Override
    public int getSelectionMode() {
        return this.selectionMode;
    }

    @Override
    public ObjectTableRowSorter<T> getRowSorter(IObjectTableModel<T> tableModel) {
        boolean flag = false;
        ObjectTableRowSorter<T> tableRowSorter = new ObjectTableRowSorter<T>(tableModel);
        int i = 0;
        while (i < this.columnConfigurations.size()) {
            IColumnConfiguration columnConfiguration = this.columnConfigurations.get(i);
            boolean isSortable = columnConfiguration.isSortable();
            tableRowSorter.setSortable(i, isSortable);
            if (columnConfiguration.getComparator() != null) {
                tableRowSorter.setComparator(i, columnConfiguration.getComparator());
            }
            flag |= isSortable;
            ++i;
        }
        return flag ? tableRowSorter : null;
    }

    @Override
    public IStringSubstituter getToolTipSubstituter() {
        return this.toolTipSubstituter;
    }

    @Override
    public ITableActionConfiguration<T> getTableActionConfiguration() {
        return this.actionConfiguration;
    }

    @Override
    public int getPreferredVisibleRowCount() {
        return this.preferredVisibleRowCount;
    }

    @Override
    public IMouseListenerFactory<T> getTableMouseListenerFactory() {
        return this.tableMouseListenerFactory;
    }

    @Override
    public IKeyListenerFactory<T> getKeyListenerFactory() {
        return this.keyListenerFactory;
    }

    @Override
    public IMouseListenerFactory<T> getHeaderMouseListenerFactory() {
        return this.headerMouseListenerFactory;
    }
}

