/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.table;

import java.util.ArrayList;
import java.util.List;
import net.anwiba.commons.swing.table.IColumnConfiguration;
import net.anwiba.commons.swing.table.IKeyListenerFactory;
import net.anwiba.commons.swing.table.IMouseListenerFactory;
import net.anwiba.commons.swing.table.IObjectTableConfiguration;
import net.anwiba.commons.swing.table.ObjectTableConfiguration;
import net.anwiba.commons.swing.table.TableActionConfiguration;
import net.anwiba.commons.swing.table.action.ITableActionFactory;

public class ObjectTableConfigurationBuilder<T> {
    private int selectionMode = 2;
    private final List<IColumnConfiguration> columnConfigurations = new ArrayList<IColumnConfiguration>();
    private final List<ITableActionFactory<T>> actionFactories = new ArrayList<ITableActionFactory<T>>();
    private int preferredVisibleRowCount = 10;
    private IMouseListenerFactory<T> headerMouseListenerFactory;
    private IMouseListenerFactory<T> tableMouseListenerFactory;
    private IKeyListenerFactory<T> keyListenerFactory;

    public void setKeyListenerFactory(IKeyListenerFactory<T> keyListenerFactory) {
        this.keyListenerFactory = keyListenerFactory;
    }

    public void setSelectionMode(int selectionMode) {
        this.selectionMode = selectionMode;
    }

    public void addColumnConfiguration(IColumnConfiguration columnConfiguration) {
        this.columnConfigurations.add(columnConfiguration);
    }

    public void addActionFactory(ITableActionFactory<T> factory) {
        this.actionFactories.add(factory);
    }

    public void setPreferredVisibleRowCount(int preferredVisibleRowCount) {
        this.preferredVisibleRowCount = preferredVisibleRowCount;
    }

    public IObjectTableConfiguration<T> build() {
        TableActionConfiguration<T> actionConfiguration = new TableActionConfiguration<T>(this.actionFactories);
        return new ObjectTableConfiguration<T>(-1, this.selectionMode, this.preferredVisibleRowCount, null, this.columnConfigurations, this.headerMouseListenerFactory, this.tableMouseListenerFactory, this.keyListenerFactory, actionConfiguration);
    }

    public void setTableMouseListenerFactory(IMouseListenerFactory<T> mouseListenerFactory) {
        this.tableMouseListenerFactory = mouseListenerFactory;
    }

    public void setHeaderMouseListenerFactory(IMouseListenerFactory<T> mouseListenerFactory) {
        this.headerMouseListenerFactory = mouseListenerFactory;
    }
}

