/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.table;

import java.awt.event.MouseEvent;
import java.util.Optional;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import net.anwiba.commons.swing.utilities.JTableUtilities;
import net.anwiba.commons.utilities.string.IStringSubstituter;

public class Table
extends JTable {
    private static final long serialVersionUID = 1L;
    private final IStringSubstituter substituter;

    public Table(TableModel tableModel) {
        this(tableModel, (IStringSubstituter)null);
    }

    public Table(TableModel tableModel, IStringSubstituter substituter) {
        super(tableModel);
        this.substituter = substituter;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        String string = this.getCellContentAsString(this, event);
        String toolTipString = Optional.ofNullable(this.substituter).map(s -> s.substitute(string)).orElse(string);
        return toolTipString;
    }

    private String getCellContentAsString(Table table, MouseEvent event) {
        String value = JTableUtilities.getToolTipText((JTable)table, event);
        if (value == null) {
            return super.getToolTipText(event);
        }
        return value;
    }
}

