/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.table.filter;

import java.util.ArrayList;
import javax.swing.table.TableModel;
import net.anwiba.commons.swing.table.IRowFilter;
import net.anwiba.commons.swing.table.IRowMapper;
import net.anwiba.commons.swing.table.filter.IColumToStringConverter;
import net.anwiba.commons.swing.table.filter.Mapper;

public class ContainsFilter
implements IRowFilter {
    private final String string;
    private final IColumToStringConverter converter;
    private final int[] columnIndexes;

    public ContainsFilter(String string, IColumToStringConverter converter) {
        this.string = string;
        this.converter = converter;
        this.columnIndexes = converter.getFilterableColumnIndicies();
    }

    @Override
    public IRowMapper filter(TableModel tableModel) {
        ArrayList<Integer> mapping = new ArrayList<Integer>();
        int i = 0;
        while (i < tableModel.getRowCount()) {
            int j = 0;
            while (j < this.columnIndexes.length) {
                if (this.accept(this.converter.convert(j, tableModel.getValueAt(i, this.columnIndexes[j])))) {
                    mapping.add(i);
                    break;
                }
                ++j;
            }
            ++i;
        }
        return new Mapper(mapping);
    }

    private boolean accept(String value) {
        if (value == null) {
            return false;
        }
        return value.toLowerCase().contains(this.string.toLowerCase());
    }
}

