/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.table.renderer;

import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import net.anwiba.commons.lang.object.ObjectUtilities;
import net.anwiba.commons.swing.ui.IObjectUi;

public class ObjectUiTableCellRenderer<T>
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;
    private final IObjectUi<T> objectUi;
    private final Class<T> clazz;
    private final int horizontalAlignment;

    public ObjectUiTableCellRenderer(IObjectUi<T> objectUi, Class<T> clazz, int horizontalAlignment) {
        this.objectUi = objectUi;
        this.clazz = clazz;
        this.horizontalAlignment = horizontalAlignment;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.setHorizontalAlignment(this.horizontalAlignment);
        if (this.clazz.isInstance(value)) {
            this.setIcon(this.objectUi.getIcon(value));
            this.setText(this.objectUi.getText(value));
            return this;
        }
        this.setIcon(null);
        this.setText(ObjectUtilities.toString((Object)value));
        return this;
    }
}

