/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.ui;

import java.util.Optional;
import javax.swing.Icon;
import net.anwiba.commons.lang.functional.IConverter;
import net.anwiba.commons.swing.ui.IObjectUi;

public class ObjectUiBuilder<T> {
    private IConverter<T, String, RuntimeException> toTextConverter;
    private IConverter<T, String, RuntimeException> toToolTipConverter;
    private IConverter<T, Icon, RuntimeException> toIconConverter;

    public ObjectUiBuilder<T> text(IConverter<T, String, RuntimeException> toTextConverter) {
        this.toTextConverter = toTextConverter;
        return this;
    }

    public ObjectUiBuilder<T> tooltip(IConverter<T, String, RuntimeException> toToolTipConverter) {
        this.toToolTipConverter = toToolTipConverter;
        return this;
    }

    public ObjectUiBuilder<T> icon(IConverter<T, Icon, RuntimeException> toIconConverter) {
        this.toIconConverter = toIconConverter;
        return this;
    }

    public IObjectUi<T> build() {
        if (this.toTextConverter == null) {
            this.toTextConverter = input -> Optional.ofNullable(input).map(i -> i.toString()).orElse(null);
        }
        return new IObjectUi<T>(){

            public String getText(T value) {
                return (String)ObjectUiBuilder.this.toTextConverter.convert(value);
            }

            @Override
            public Icon getIcon(T object) {
                if (ObjectUiBuilder.this.toIconConverter == null) {
                    return null;
                }
                return (Icon)ObjectUiBuilder.this.toIconConverter.convert(object);
            }

            @Override
            public String getToolTipText(T object) {
                if (ObjectUiBuilder.this.toToolTipConverter == null) {
                    return this.getText(object);
                }
                return (String)ObjectUiBuilder.this.toToolTipConverter.convert(object);
            }
        };
    }
}

