/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.ui;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import net.anwiba.commons.swing.ui.IObjectUi;
import net.anwiba.commons.swing.ui.IObjectUiCellRendererConfiguration;

public class ObjectUiTableCellRenderer<T>
extends DefaultTableCellRenderer {
    private final IObjectUi<T> objectUi;
    private final IObjectUiCellRendererConfiguration configuration;
    private static final long serialVersionUID = 1L;

    public ObjectUiTableCellRenderer(IObjectUi<T> objectUi) {
        this(null, objectUi);
    }

    public ObjectUiTableCellRenderer(IObjectUiCellRendererConfiguration configuration, IObjectUi<T> objectUi) {
        this.configuration = configuration;
        this.objectUi = objectUi;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        try {
            Object object = value;
            String text = this.objectUi.getText(object);
            Icon icon = this.objectUi.getIcon(object);
            super.getTableCellRendererComponent(table, icon == null && (text == null || text.length() == 0) ? " " : text, isSelected, hasFocus, row, column);
            this.setIcon(icon);
            this.setToolTipText(this.objectUi.getToolTipText(object));
            if (this.configuration == null) {
                return this;
            }
            this.setVerticalTextPosition(this.configuration.getVerticalTextPosition());
            this.setVerticalAlignment(this.configuration.getVerticalAlignment());
            this.setHorizontalTextPosition(this.configuration.getHorizontalTextPosition());
            this.setHorizontalAlignment(this.configuration.getHorizontalAlignment());
            this.setIconTextGap(this.configuration.getIconTextGap());
            this.setBorder(this.configuration.getBorder());
            return this;
        }
        catch (ClassCastException classCastException) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            return this;
        }
    }
}

