/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.utilities;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JPanel;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.swing.utilities.ContainerUtilities;

public class GuiUtilities
extends ContainerUtilities {
    private static ILogger logger = Logging.getLogger((String)GuiUtilities.class.getName());

    public static void center(Window window) {
        if (window == null) {
            return;
        }
        Window owner = window.getOwner();
        if (owner == null || owner.getBounds().equals(new Rectangle(0, 0, 0, 0))) {
            GuiUtilities.centerToScreen(window);
            return;
        }
        int x = owner.getX() + owner.getWidth() / 2 - window.getWidth() / 2;
        int y = owner.getY() + owner.getHeight() / 2 - window.getHeight() / 2;
        window.setLocation(x < 0 ? 0 : x, y < 0 ? 0 : y);
    }

    public static void centerToScreen(Window window) {
        if (window == null) {
            return;
        }
        DisplayMode displayMode = window.getGraphicsConfiguration().getDevice().getDisplayMode();
        Point location = GuiUtilities.getCenterToScreenLocation(displayMode, window.getSize());
        window.setLocation(location);
    }

    public static Point getCenterToScreenLocation(DisplayMode displayMode, Dimension size) {
        if (displayMode == null) {
            return new Point();
        }
        int x = displayMode.getWidth() / 2 - size.width / 2;
        int y = displayMode.getHeight() / 2 - size.height / 2;
        return new Point(x, y);
    }

    public static void invokeLater(Runnable runner) {
        if (EventQueue.isDispatchThread()) {
            runner.run();
            return;
        }
        EventQueue.invokeLater(runner);
    }

    public static void invokeAndWait(Runnable runner) {
        if (EventQueue.isDispatchThread()) {
            runner.run();
            return;
        }
        try {
            EventQueue.invokeAndWait(runner);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException exception) {
            Throwable cause = exception.getCause();
            logger.log(ILevel.DEBUG, cause.getLocalizedMessage(), cause);
            throw new RuntimeException(cause);
        }
    }

    public static Component createGap(int width, boolean isElastic) {
        JPanel panel = new JPanel();
        panel.setMinimumSize(new Dimension(width, 0));
        if (!isElastic) {
            panel.setMaximumSize(new Dimension(width, 1000));
        }
        return panel;
    }
}

