/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.table.demo;

import de.jdemo.annotation.Demo;
import de.jdemo.extensions.SwingDemoCase;
import de.jdemo.junit.DemoAsTestRunner;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.Collection;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import net.anwiba.commons.model.ISelectionListener;
import net.anwiba.commons.model.SelectionEvent;
import net.anwiba.commons.swing.table.IColumnObjectFactory;
import net.anwiba.commons.swing.table.IColumnValueAdaptor;
import net.anwiba.commons.swing.table.IColumnValueProvider;
import net.anwiba.commons.swing.table.IObjectListTableConfiguration;
import net.anwiba.commons.swing.table.ObjectListColumnConfiguration;
import net.anwiba.commons.swing.table.ObjectListTable;
import net.anwiba.commons.swing.table.ObjectListTableConfigurationBuilder;
import net.anwiba.commons.swing.table.ObjectTableBuilder;
import net.anwiba.commons.swing.table.demo.DemoObject;
import net.anwiba.commons.swing.table.demo.DemoObjectFactory;
import net.anwiba.commons.swing.table.filter.ColumnToStingConverter;
import net.anwiba.commons.swing.table.filter.IColumToStringConverter;
import net.anwiba.commons.swing.table.renderer.BooleanRenderer;
import net.anwiba.commons.swing.table.renderer.NumberTableCellRenderer;
import net.anwiba.commons.swing.table.renderer.ObjectTableCellRenderer;
import net.anwiba.commons.utilities.collection.IterableUtilities;
import org.junit.runner.RunWith;

@RunWith(value=DemoAsTestRunner.class)
public class ObjectListTableDemo
extends SwingDemoCase {
    final DemoObjectFactory factory = new DemoObjectFactory(4711L);
    final IColumnObjectFactory<DemoObject, DemoObject, RuntimeException> columnObjectFactory = new IColumnObjectFactory<DemoObject, DemoObject, RuntimeException>(){

        public DemoObject create(Component parent, DemoObject value) throws RuntimeException {
            return ObjectListTableDemo.this.factory.createObject();
        }
    };

    public IObjectListTableConfiguration<DemoObject> createObjectTableConfiguration(boolean isSortable) {
        ObjectListTableConfigurationBuilder builder = new ObjectListTableConfigurationBuilder();
        this.addColumnDescriptions((ObjectListTableConfigurationBuilder<DemoObject>)builder, isSortable);
        return builder.build();
    }

    public void addColumnDescriptions(ObjectListTableConfigurationBuilder<DemoObject> builder, boolean isSortable) {
        builder.addColumnConfiguration(this.createNumberColumn(isSortable));
        builder.addColumnConfiguration(this.createNameColumn(isSortable));
        builder.addColumnConfiguration(this.createValueColumn(isSortable));
        builder.addColumnConfiguration(this.createFlagColumn(isSortable));
    }

    public ObjectListColumnConfiguration<DemoObject> createFlagColumn(boolean isSortable) {
        return new ObjectListColumnConfiguration((Object)"Flag", (IColumnValueProvider)new IColumnValueProvider<DemoObject>(){

            public Object getValue(DemoObject object) {
                if (object == null) {
                    return null;
                }
                return object.getFlag();
            }
        }, (TableCellRenderer)new BooleanRenderer(), (IColumnValueAdaptor)new IColumnValueAdaptor<DemoObject>(){

            public DemoObject adapt(DemoObject object, Object value) {
                if (object == null) {
                    return new DemoObject(null, null, null, (Boolean)value);
                }
                return new DemoObject(object.getNummer(), object.getName(), object.getValue(), (Boolean)value);
            }
        }, (TableCellEditor)new DefaultCellEditor(new JCheckBox()), 40, isSortable, null);
    }

    public ObjectListColumnConfiguration<DemoObject> createValueColumn(boolean isSortable) {
        return new ObjectListColumnConfiguration((Object)"Value", (IColumnValueProvider)new IColumnValueProvider<DemoObject>(){

            public Object getValue(DemoObject object) {
                if (object == null) {
                    return null;
                }
                return object.getValue();
            }
        }, (TableCellRenderer)new NumberTableCellRenderer(), 200, isSortable, null);
    }

    public ObjectListColumnConfiguration<DemoObject> createNameColumn(boolean isSortable) {
        return new ObjectListColumnConfiguration((Object)"Name", (IColumnValueProvider)new IColumnValueProvider<DemoObject>(){

            public Object getValue(DemoObject object) {
                if (object == null) {
                    return null;
                }
                return object.getName();
            }
        }, (TableCellRenderer)new ObjectTableCellRenderer(), (IColumnValueAdaptor)new IColumnValueAdaptor<DemoObject>(){

            public DemoObject adapt(DemoObject object, Object value) {
                if (object == null) {
                    return new DemoObject(null, (String)value, null, null);
                }
                return new DemoObject(object.getNummer(), (String)value, object.getValue(), object.getFlag());
            }
        }, (TableCellEditor)new DefaultCellEditor(new JTextField()), 200, isSortable, null);
    }

    public ObjectListColumnConfiguration<DemoObject> createNumberColumn(boolean isSortable) {
        return new ObjectListColumnConfiguration((Object)"Nummer", (IColumnValueProvider)new IColumnValueProvider<DemoObject>(){

            public Object getValue(DemoObject object) {
                if (object == null) {
                    return null;
                }
                return object.getNummer();
            }
        }, (TableCellRenderer)new NumberTableCellRenderer(), 80, isSortable, null);
    }

    @Demo
    public void actions() {
        ObjectListTableConfigurationBuilder builder = new ObjectListTableConfigurationBuilder();
        this.addColumnDescriptions((ObjectListTableConfigurationBuilder<DemoObject>)builder, true);
        builder.addAddObjectAction(this.columnObjectFactory).addEditObjectAction(this.columnObjectFactory).addRemoveObjectsAction().addMoveObjectUpAction().addMoveObjectDownAction();
        this.show(new ObjectListTable(builder.build(), this.factory.createObjectList(20)).getComponent());
    }

    @Demo
    public void sortable() {
        ObjectListTableConfigurationBuilder builder = new ObjectListTableConfigurationBuilder();
        this.addColumnDescriptions((ObjectListTableConfigurationBuilder<DemoObject>)builder, true);
        this.show(new ObjectListTable(builder.build(), this.factory.createObjectList(20)).getComponent());
    }

    @Demo
    public void selection() {
        JPanel panel = new JPanel(new GridLayout(2, 1));
        List<DemoObject> objectList = this.factory.createObjectList(20);
        final ObjectListTable masterTable = new ObjectListTable(this.createObjectTableConfiguration(true), objectList);
        final ObjectListTable minorTable = new ObjectListTable(this.createObjectTableConfiguration(true), objectList);
        panel.add(masterTable.getComponent());
        panel.add(minorTable.getComponent());
        masterTable.getSelectionModel().addSelectionListener((ISelectionListener)new ISelectionListener<DemoObject>(){

            public void selectionChanged(SelectionEvent<DemoObject> event) {
                List objects = IterableUtilities.asList((Iterable)masterTable.getSelectionModel().getSelectedObjects());
                minorTable.getSelectionModel().setSelectedObjects((Collection)objects);
            }
        });
        minorTable.getSelectionModel().addSelectionListener((ISelectionListener)new ISelectionListener<DemoObject>(){

            public void selectionChanged(SelectionEvent<DemoObject> event) {
                List objects = IterableUtilities.asList((Iterable)minorTable.getSelectionModel().getSelectedObjects());
                masterTable.getSelectionModel().setSelectedObjects((Collection)objects);
            }
        });
        this.show(panel);
    }

    @Demo
    public void filterable() {
        ObjectTableBuilder builder = new ObjectTableBuilder();
        builder.setValues(this.factory.createObjectList(20));
        builder.addColumn(this.createNumberColumn(true));
        builder.addColumn(this.createNameColumn(true));
        builder.addColumn(this.createValueColumn(true));
        builder.addColumn(this.createFlagColumn(true));
        builder.addAddObjectAction(this.columnObjectFactory).addEditObjectAction(this.columnObjectFactory).addRemoveObjectsAction().addMoveObjectUpAction().addMoveObjectDownAction().setFilterToStringConverter((IColumToStringConverter)new ColumnToStingConverter(new int[]{0, 1, 2, 3}));
        this.show(builder.build().getComponent());
    }
}

