/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.date;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import net.anwiba.commons.lang.optional.IOptional;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.model.IChangeableObjectListener;
import net.anwiba.commons.model.IObjectModel;
import net.anwiba.commons.model.ObjectModel;
import net.anwiba.commons.swing.date.DatePanel;
import net.anwiba.commons.swing.date.MonthViewFocusTraversalPolicy;
import net.anwiba.commons.swing.date.event.DateSelectionEvent;
import net.anwiba.commons.swing.date.event.DateSelectionListener;
import net.anwiba.commons.swing.date.event.MonthChangedEvent;
import net.anwiba.commons.swing.date.event.MonthChangedListener;
import net.anwiba.commons.swing.icons.GuiIcons;
import net.anwiba.commons.swing.icons.gnome.contrast.high.ContrastHightIcons;
import net.anwiba.commons.swing.object.IObjectField;
import net.anwiba.commons.swing.object.IntegerFieldBuilder;
import net.anwiba.commons.swing.utilities.GuiUtilities;

public class MonthView
extends JPanel {
    private static final long serialVersionUID = 1L;
    DatePanel[][] datePanes = null;
    IObjectModel<Date> selectedDateModel = new ObjectModel();
    JToolBar toolBar = null;
    int month = 0;
    int year = 0;
    int height = 6;
    int width = 7;
    IObjectModel<Integer> yearModel = new ObjectModel();
    JComboBox<String> monthBox = null;
    private final IObjectModel<LocalDate> dateModel;

    public MonthView() {
        this((IObjectModel<LocalDate>)new ObjectModel((Object)LocalDate.now()));
    }

    public MonthView(IObjectModel<LocalDate> dateModel) {
        this(dateModel, 6, 7);
    }

    public MonthView(IObjectModel<LocalDate> dateModel, int height, int width) {
        if (height * width != 42) {
            throw new IllegalArgumentException("program error: dayfield number is not 42");
        }
        if (width % 7 != 0) {
            throw new IllegalArgumentException("program error: week lenght is not a mutiple of 7");
        }
        this.dateModel = dateModel;
        this.height = height;
        this.width = width;
        this.init();
    }

    public void init() {
        this.setLayout(new BorderLayout(0, 0));
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.toolBar = new JToolBar("Month");
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        JButton firstButton = new JButton();
        firstButton.setAction(new FirstAction());
        firstButton.setFocusable(false);
        firstButton.setFocusPainted(false);
        firstButton.setText(null);
        this.toolBar.add(firstButton);
        JButton previousButton = new JButton();
        previousButton.setAction(new PreviousAction());
        previousButton.setFocusable(false);
        previousButton.setFocusPainted(false);
        previousButton.setText(null);
        this.toolBar.add(previousButton);
        String[] months = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
        this.monthBox = new JComboBox<String>(months);
        this.monthBox.setAction(new MonthAction());
        this.toolBar.add(this.monthBox);
        IObjectField yearField = ((IntegerFieldBuilder)((IntegerFieldBuilder)((IntegerFieldBuilder)new IntegerFieldBuilder().setModel(this.yearModel)).setColumns(6)).setToolTip("Year")).addSpinnerActions(Integer.MIN_VALUE, Integer.MAX_VALUE, 1).build();
        this.yearModel.addChangeListener(new IChangeableObjectListener(){

            public void objectChanged() {
                if (MonthView.this.year == (Integer)MonthView.this.yearModel.get()) {
                    return;
                }
                MonthView.this.setMonth((Integer)MonthView.this.yearModel.get(), MonthView.this.month);
            }
        });
        this.toolBar.add(yearField.getComponent());
        JButton nextButton = new JButton();
        nextButton.setAction(new NextAction());
        nextButton.setFocusable(false);
        nextButton.setFocusPainted(false);
        nextButton.setText(null);
        this.toolBar.add(nextButton);
        JButton lastButton = new JButton();
        lastButton.setAction(new LastAction());
        lastButton.setFocusable(false);
        lastButton.setFocusPainted(false);
        lastButton.setText(null);
        this.toolBar.add(lastButton);
        this.toolBar.add(new JPanel());
        JPanel toolBarPane = new JPanel();
        toolBarPane.setLayout(new FlowLayout(0, 0, 0));
        toolBarPane.add(this.toolBar);
        JPanel daysPane = new JPanel();
        daysPane.setLayout(new GridLayout(1, this.width));
        String[] days = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
        JPanel dayPane = null;
        JLabel dayLabel = null;
        int i = 0;
        while (i < this.width) {
            dayPane = new JPanel();
            dayPane.setLayout(new BorderLayout(0, 0));
            dayPane.setBorder(BorderFactory.createLineBorder(this.getBackground()));
            if (i % 7 == 0) {
                dayPane.setBackground(Color.gray);
            } else {
                dayPane.setBackground(Color.decode("#AAAAAA"));
            }
            dayLabel = new JLabel(days[i % 7]);
            dayPane.add((Component)dayLabel, "North");
            daysPane.add(dayPane);
            ++i;
        }
        this.datePanes = new DatePanel[this.height][this.width];
        JPanel datesPane = new JPanel();
        datesPane.setLayout(new GridLayout(this.height, this.width));
        DateSelectionListener dateSelectionListener = new DateSelectionListener(){

            @Override
            public void selectionOccurred(DateSelectionEvent event) {
                Object source = event.getSource();
                if (source instanceof DatePanel) {
                    DatePanel datePane = (DatePanel)source;
                    if (MonthView.this.selectedDateModel.get() == null || !((Date)MonthView.this.selectedDateModel.get()).equals(datePane.getDate())) {
                        int era = datePane.getERA();
                        int year = era == 1 ? datePane.getYear() : (datePane.getYear() - 1) * -1;
                        int month = datePane.getMonth();
                        int day = datePane.getDay();
                        if (MonthView.this.month == month && MonthView.this.year == year) {
                            if (MonthView.this.selectedDateModel.get() != null) {
                                GregorianCalendar calendar = new GregorianCalendar();
                                calendar.setTime((Date)MonthView.this.selectedDateModel.get());
                                Point pos = MonthView.this.getPosition(calendar.get(0) == 1 ? calendar.get(1) : calendar.get(1) * -1, calendar.get(2), calendar.get(5));
                                DatePanel selectedDayPane = MonthView.this.datePanes[pos.x][pos.y];
                                selectedDayPane.setSelected(false);
                            }
                            MonthView.this.selectedDateModel.set((Object)datePane.getDate());
                            if (!datePane.hasFocus()) {
                                datePane.requestFocus();
                            }
                        } else {
                            MonthView.this.setSelectedDate(year, month, day);
                        }
                        MonthView.this.fireSelectionOccured((DatePanel)source);
                    }
                }
            }

            @Override
            public void deselectionOccurred(DateSelectionEvent event) {
                Object source = event.getSource();
                if (source instanceof DatePanel && MonthView.this.selectedDateModel.get() != null && ((Date)MonthView.this.selectedDateModel.get()).equals(((DatePanel)source).getDate())) {
                    MonthView.this.selectedDateModel.set(null);
                    MonthView.this.fireDeselectionOccured((DatePanel)source);
                }
            }
        };
        int i2 = 0;
        while (i2 < this.height) {
            int j = 0;
            while (j < this.width) {
                DatePanel datePane = new DatePanel();
                datePane.setFocusable(true);
                datePane.setGridColor(this.getBackground());
                datePane.addDaySelectionListener(dateSelectionListener);
                datesPane.add(datePane);
                this.datePanes[i2][j] = datePane;
                ++j;
            }
            ++i2;
        }
        JPanel monthPane = new JPanel();
        monthPane.setLayout(new BorderLayout(0, 0));
        monthPane.add((Component)daysPane, "North");
        monthPane.add((Component)datesPane, "Center");
        this.add((Component)toolBarPane, "North");
        this.add((Component)monthPane, "Center");
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(new MonthViewFocusTraversalPolicy(this.datePanes));
        Optional.of((Object)((LocalDate)this.dateModel.get())).consume(d -> this.setSelectedDate(d.getYear(), d.getMonthValue() - 1, d.getDayOfMonth())).or(() -> {
            LocalDate d = LocalDate.now();
            GuiUtilities.invokeLater(() -> this.setMonth(d.getYear(), d.getMonthValue() - 1));
        }).getOr(() -> LocalDate.now());
        this.dateModel.addChangeListener(() -> {
            IOptional iOptional = Optional.of((Object)((LocalDate)this.dateModel.get())).consume(d -> this.setSelectedDate(d.getYear(), d.getMonthValue() - 1, d.getDayOfMonth())).or(() -> GuiUtilities.invokeLater(() -> {
                int i = 0;
                while (i < this.height) {
                    int j = 0;
                    while (j < this.width) {
                        this.datePanes[i][j].setSelected(false);
                        ++j;
                    }
                    ++i;
                }
            }));
        });
        this.selectedDateModel.addChangeListener(() -> {
            IOptional iOptional = Optional.of((Object)((Date)this.selectedDateModel.get())).consume(d -> this.dateModel.set((Object)Instant.ofEpochMilli(d.getTime()).atZone(ZoneId.systemDefault()).toLocalDate())).or(() -> this.dateModel.set(null));
        });
    }

    void setMonth(int year, int month) {
        if (this.year == year && this.month == month) {
            return;
        }
        this.year = year;
        this.month = month;
        this.monthBox.setSelectedIndex(month);
        this.yearModel.set((Object)year);
        GregorianCalendar date = new GregorianCalendar();
        date = this.getDate(year, month, 1);
        int day = 1 - (date.get(7) - date.get(8));
        DatePanel datePane = null;
        int i = 0;
        while (i < this.height) {
            int j = 0;
            while (j < this.width) {
                if (year == 1582 && month == 9 && day == 5) {
                    day = 15;
                }
                date = this.getDate(year, month, day++);
                datePane = this.datePanes[i][j];
                datePane.setDate(date, true);
                if (month == date.get(2)) {
                    if (date.get(7) == 1) {
                        datePane.setBackground(Color.lightGray);
                        datePane.setForeground(Color.black);
                    } else {
                        datePane.setBackground(Color.white);
                        datePane.setForeground(Color.black);
                    }
                } else if (date.get(7) == 1) {
                    datePane.setBackground(Color.gray.darker());
                    datePane.setForeground(Color.white);
                } else {
                    datePane.setBackground(Color.gray);
                    datePane.setForeground(Color.white);
                }
                ++j;
            }
            ++i;
        }
        date = this.getDate(year, month, 1);
        this.fireMonthChanged(date.getTime());
    }

    int getMonth() {
        return this.month;
    }

    int getYear() {
        return this.year;
    }

    public void setSelectedDate(int year, int month, int day) {
        this.setMonth(year, month);
        Point pos = this.getPosition(year, month, day);
        DatePanel datePane = this.datePanes[pos.x][pos.y];
        if (this.selectedDateModel.get() == null || !((Date)this.selectedDateModel.get()).equals(datePane.getDate())) {
            datePane.setSelected(true);
            if (!datePane.hasFocus()) {
                datePane.requestFocus();
            }
        }
    }

    private Point getPosition(int year, int month, int day) {
        GregorianCalendar date = null;
        DatePanel nullPane = this.datePanes[0][0];
        date = this.getDate(nullPane.getERA() == 1 ? nullPane.getYear() : (nullPane.getYear() - 1) * -1, nullPane.getMonth(), nullPane.getDay());
        int firstDate = date.get(6);
        date = this.getDate(year, month, day);
        int selectedDate = date.get(6);
        if (year == 1582 && month == 9 && day > 4) {
            selectedDate -= 10;
        }
        if (firstDate > selectedDate) {
            selectedDate = this.getDate(year - 1, 11, 31).get(6) + selectedDate;
        }
        int difference = selectedDate - firstDate;
        int dayOfWeek = difference % this.width;
        int weekOfMonth = difference / this.width;
        return new Point(weekOfMonth, dayOfWeek);
    }

    public Date getSelectedDate() {
        return (Date)this.selectedDateModel.get();
    }

    public IObjectModel<LocalDate> getDateModel() {
        return this.dateModel;
    }

    private GregorianCalendar getDate(int year, int month, int day) {
        GregorianCalendar date = new GregorianCalendar(year, month, day);
        if (year < 1) {
            date.set(0, 1);
        }
        return date;
    }

    protected void fireSelectionOccured(DatePanel datePane) {
        Object[] listeners = this.listenerList.getListenerList();
        DateSelectionEvent e = null;
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == DateSelectionListener.class) {
                if (e == null) {
                    e = new DateSelectionEvent(this, datePane.getDate());
                }
                ((DateSelectionListener)listeners[i + 1]).selectionOccurred(e);
            }
            i -= 2;
        }
    }

    protected void fireDeselectionOccured(DatePanel datePane) {
        Object[] listeners = this.listenerList.getListenerList();
        DateSelectionEvent e = null;
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == DateSelectionListener.class) {
                if (e == null) {
                    e = new DateSelectionEvent(this, datePane.getDate());
                }
                ((DateSelectionListener)listeners[i + 1]).deselectionOccurred(e);
            }
            i -= 2;
        }
    }

    public void addDaySelectionListener(DateSelectionListener l) {
        this.listenerList.add(DateSelectionListener.class, l);
    }

    public void removeDaySelectionListener(DateSelectionListener l) {
        this.listenerList.remove(DateSelectionListener.class, l);
    }

    protected void fireMonthChanged(Date date) {
        Object[] listeners = this.listenerList.getListenerList();
        MonthChangedEvent e = null;
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == MonthChangedListener.class) {
                if (e == null) {
                    e = new MonthChangedEvent(this, date);
                }
                ((MonthChangedListener)listeners[i + 1]).monthChanged(e);
            }
            i -= 2;
        }
    }

    public void addMonthChangeListener(MonthChangedListener l) {
        this.listenerList.add(MonthChangedListener.class, l);
    }

    public void removeMonthChangeListener(MonthChangedListener l) {
        this.listenerList.remove(MonthChangedListener.class, l);
    }

    private class FirstAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public FirstAction() {
            super("First", ContrastHightIcons.MEDIA_SEEK_FORWARD_RTL.getSmallIcon());
            this.putValue("ShortDescription", "first month");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            int m = -1;
            int y = -1;
            if (MonthView.this.month == 0) {
                y = MonthView.this.year - 1;
                m = MonthView.this.month;
            } else {
                y = MonthView.this.year;
                m = 0;
            }
            MonthView.this.setMonth(y, m);
        }
    }

    private class LastAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public LastAction() {
            super("Last", ContrastHightIcons.MEDIA_SEEK_FORWARD.getSmallIcon());
            this.putValue("ShortDescription", "last month");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            int m = -1;
            int y = -1;
            if (MonthView.this.month == 11) {
                y = MonthView.this.year + 1;
                m = MonthView.this.month;
            } else {
                y = MonthView.this.year;
                m = 11;
            }
            MonthView.this.setMonth(y, m);
        }
    }

    private class MonthAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public MonthAction() {
            super("Month", GuiIcons.MISC_ICON.getSmallIcon());
            this.putValue("ShortDescription", "set month");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (MonthView.this.month == MonthView.this.monthBox.getSelectedIndex()) {
                return;
            }
            MonthView.this.setMonth(MonthView.this.year, MonthView.this.monthBox.getSelectedIndex());
        }
    }

    private class NextAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public NextAction() {
            super("Next", ContrastHightIcons.MEDIA_PLAYBACK_START.getSmallIcon());
            this.putValue("ShortDescription", "next month");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            int m = -1;
            int y = -1;
            if (MonthView.this.month == 11) {
                y = MonthView.this.year + 1;
                m = 0;
            } else {
                y = MonthView.this.year;
                m = MonthView.this.month + 1;
            }
            MonthView.this.setMonth(y, m);
        }
    }

    private class PreviousAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public PreviousAction() {
            super("Previous", ContrastHightIcons.MEDIA_PLAYBACK_START_RTL.getSmallIcon());
            this.putValue("ShortDescription", "previous month");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            int m = -1;
            int y = -1;
            if (MonthView.this.month == 0) {
                y = MonthView.this.year - 1;
                m = 11;
            } else {
                y = MonthView.this.year;
                m = MonthView.this.month - 1;
            }
            MonthView.this.setMonth(y, m);
        }
    }
}

