/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.date;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Point;
import java.util.GregorianCalendar;
import net.anwiba.commons.swing.date.DatePanel;
import net.anwiba.commons.swing.date.MonthView;

public class MonthViewFocusTraversalPolicy
extends FocusTraversalPolicy {
    final DatePanel[][] datePanes;
    final int height;
    final int width;

    public MonthViewFocusTraversalPolicy(DatePanel[][] datePanes) {
        this.datePanes = datePanes;
        this.height = this.datePanes.length;
        this.width = this.datePanes[0].length;
    }

    @Override
    public Component getComponentAfter(Container focusCycleRoot, Component component) {
        if (component instanceof DatePanel) {
            int era = ((DatePanel)component).getERA();
            int year = era == 1 ? ((DatePanel)component).getYear() : (((DatePanel)component).getYear() - 1) * -1;
            int month = ((DatePanel)component).getMonth();
            int day = ((DatePanel)component).getDay();
            Point pos = this.getCurrentPosition(year, month, day);
            if (pos.x == this.height - 1 && pos.y == this.width - 1) {
                if (month == 11) {
                    ((MonthView)focusCycleRoot).setMonth(year + 1, 0);
                } else {
                    ((MonthView)focusCycleRoot).setMonth(year, month + 1);
                }
                pos = this.getCurrentPosition(year, month + 1, 1);
            } else if (pos.y == this.width - 1) {
                ++pos.x;
                pos.y = 0;
            } else {
                ++pos.y;
            }
            if (pos.x > 0 && pos.x < this.datePanes.length && pos.y > 0 && pos.y < this.datePanes[pos.x].length) {
                return this.datePanes[pos.x][pos.y];
            }
        }
        return this.getDefaultComponent(focusCycleRoot);
    }

    @Override
    public Component getLastComponent(Container focusCycleRoot) {
        int year = ((MonthView)focusCycleRoot).getYear();
        int month = ((MonthView)focusCycleRoot).getMonth();
        Point pos = this.getCurrentPosition(year, month + 1, -1);
        return this.datePanes[pos.x][pos.y];
    }

    @Override
    public Component getFirstComponent(Container focusCycleRoot) {
        int year = ((MonthView)focusCycleRoot).getYear();
        int month = ((MonthView)focusCycleRoot).getMonth();
        Point pos = this.getCurrentPosition(year, month, 1);
        return this.datePanes[pos.x][pos.y];
    }

    @Override
    public Component getDefaultComponent(Container focusCycleRoot) {
        int year = ((MonthView)focusCycleRoot).getYear();
        int month = ((MonthView)focusCycleRoot).getMonth();
        Point pos = this.getCurrentPosition(year, month, 1);
        return this.datePanes[pos.x][pos.y];
    }

    @Override
    public Component getComponentBefore(Container focusCycleRoot, Component component) {
        if (component instanceof DatePanel) {
            int era = ((DatePanel)component).getERA();
            int year = era == 1 ? ((DatePanel)component).getYear() : (((DatePanel)component).getYear() - 1) * -1;
            int month = ((DatePanel)component).getMonth();
            int day = ((DatePanel)component).getDay();
            Point pos = this.getCurrentPosition(year, month, day);
            if (pos.x == 0 && pos.y == 0) {
                if (month == 0) {
                    ((MonthView)focusCycleRoot).setMonth(year - 1, 11);
                } else {
                    ((MonthView)focusCycleRoot).setMonth(year, month - 1);
                }
                pos = this.getCurrentPosition(year, month, day - 1);
            } else if (pos.y == 0) {
                --pos.x;
                pos.y = this.width - 1;
            } else {
                --pos.y;
            }
            if (pos.x > 0 && pos.x < this.datePanes.length && pos.y > 0 && pos.y < this.datePanes[pos.x].length) {
                return this.datePanes[pos.x][pos.y];
            }
        }
        return this.getDefaultComponent(focusCycleRoot);
    }

    private Point getCurrentPosition(int year, int month, int day) {
        DatePanel nullPane = this.datePanes[0][0];
        int firstDate = this.getDayOfYear(nullPane.getERA() == 1 ? nullPane.getYear() : (nullPane.getYear() - 1) * -1, nullPane.getMonth(), nullPane.getDay());
        int selectedDate = this.getDayOfYear(year, month, day);
        if (year == 1582 && month == 9 && day > 4) {
            selectedDate -= 10;
        }
        if (firstDate > selectedDate) {
            selectedDate = this.getDate(year - 1, 11, 31).get(6) + selectedDate;
        }
        int difference = selectedDate - firstDate;
        int dayOfWeek = difference % this.width;
        int weekOfMonth = difference / this.width;
        return new Point(weekOfMonth, dayOfWeek);
    }

    private int getDayOfYear(int year, int month, int day) {
        return this.getDate(year, month, day).get(6);
    }

    private GregorianCalendar getDate(int year, int month, int day) {
        GregorianCalendar date = new GregorianCalendar(year, month, day);
        if (year < 1) {
            date.set(0, 1);
        }
        return date;
    }
}

