/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.dialog.exception;

import java.awt.Component;
import java.awt.Window;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.anwiba.commons.message.ExceptionMessage;
import net.anwiba.commons.message.IMessage;
import net.anwiba.commons.swing.dialog.DialogMessages;
import net.anwiba.commons.swing.dialog.DialogType;
import net.anwiba.commons.swing.dialog.MessageDialog;
import net.anwiba.commons.swing.icons.GuiIcons;

public class ExceptionDialog
extends MessageDialog {
    private static final long serialVersionUID = 1L;
    final ExceptionMessage exceptionMessage;
    JScrollPane detailsPanel;

    public ExceptionDialog(Window owner, Throwable throwable) {
        this(owner, new ExceptionMessage(throwable.getClass().getSimpleName(), throwable.getLocalizedMessage(), throwable));
    }

    public ExceptionDialog(Window owner, ExceptionMessage message) {
        super(owner, DialogMessages.ERROR, (IMessage)message, (Icon)GuiIcons.EMPTY_ICON.getLargeIcon(), DialogType.CLOSE_DETIALS);
        this.exceptionMessage = message;
    }

    @Override
    protected Component getDetailsComponent() {
        if (this.detailsPanel == null) {
            JTextArea textArea = new JTextArea();
            this.detailsPanel = new JScrollPane(textArea);
            textArea.setEditable(false);
            textArea.setLineWrap(false);
            textArea.setRows(15);
            textArea.setColumns(40);
            StringWriter stringWriter = new StringWriter();
            this.exceptionMessage.getThrowable().printStackTrace(new PrintWriter(stringWriter));
            textArea.append(stringWriter.getBuffer().toString());
        }
        return this.detailsPanel;
    }

    public static void show(Window owner, ExceptionMessage message) {
        ExceptionDialog exceptionDialog = new ExceptionDialog(owner, message);
        exceptionDialog.setVisible(true);
    }

    public static void show(Window owner, Throwable e) {
        ExceptionDialog exceptionDialog = new ExceptionDialog(owner, e);
        exceptionDialog.setVisible(true);
    }
}

