/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.filechooser;

import javax.swing.JFileChooser;
import net.anwiba.commons.preferences.IPreferences;
import net.anwiba.commons.preferences.UserPreferencesFactory;
import net.anwiba.commons.swing.filechooser.FileChoosers;
import net.anwiba.commons.swing.filechooser.IFileChooserPanel;
import net.anwiba.commons.swing.filechooser.IOpenFileChooserConfiguration;
import net.anwiba.commons.swing.filechooser.ISaveFileChooserConfiguration;
import net.anwiba.commons.swing.filechooser.MultiFileChooserPanel;
import net.anwiba.commons.swing.filechooser.SingleFileChooserPanel;

public class FileChooserPanelFactory {
    private final IPreferences preferences;

    public FileChooserPanelFactory() {
        this(new UserPreferencesFactory(new String[0]).create("/net/anwiba/gui"));
    }

    public FileChooserPanelFactory(IPreferences preferences) {
        this.preferences = preferences.node(new String[]{"filechooser"});
    }

    public IFileChooserPanel create(IOpenFileChooserConfiguration configuration) {
        JFileChooser fileChooser = FileChoosers.createOpenFileChooser(this.preferences, configuration);
        fileChooser.setControlButtonsAreShown(false);
        if (configuration.isMultiSelectionEnabled()) {
            return new MultiFileChooserPanel(fileChooser, this.preferences);
        }
        return new SingleFileChooserPanel(fileChooser, this.preferences);
    }

    public IFileChooserPanel create(ISaveFileChooserConfiguration configuration) {
        JFileChooser fileChooser = FileChoosers.createSaveFileChooser(this.preferences, configuration);
        fileChooser.setControlButtonsAreShown(false);
        if (configuration.isMultiSelectionEnabled()) {
            return new MultiFileChooserPanel(fileChooser, this.preferences);
        }
        return new SingleFileChooserPanel(fileChooser, this.preferences);
    }
}

