/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.menu;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import net.anwiba.commons.lang.functional.IBlock;
import net.anwiba.commons.model.IChangeableListListener;
import net.anwiba.commons.swing.menu.ActionListModel;

public class ActionListMenu
extends JMenu {
    private static final long serialVersionUID = 1L;

    public ActionListMenu(String title, ActionListModel actionListModel, int limit, Action action) {
        super(title);
        int limited = limit;
        final Action limitReachedAction = action;
        actionListModel.addListModelListener((IChangeableListListener)new IChangeableListListener<Action>(limited){
            private final Set<Action> visibleActions = new HashSet<Action>();
            private final Set<Action> hiddenActions = new HashSet<Action>();
            private final Set<Action> limitReachedActions = new HashSet<Action>();
            private final AtomicInteger counter = new AtomicInteger(0);
            private final int limit;
            {
                this.limit = n;
            }

            private void execute(IBlock<RuntimeException> block) {
                this.limitReachedActions.forEach(a -> ActionListMenu.this.remove((Action)a));
                this.limitReachedActions.clear();
                block.execute();
                if (this.counter.get() >= this.limit) {
                    this.limitReachedActions.add(limitReachedAction);
                    ActionListMenu.this.add(limitReachedAction);
                }
            }

            public void objectsAdded(Iterable<Integer> indeces, Iterable<Action> actions) {
                this.execute((IBlock<RuntimeException>)((IBlock)() -> {
                    for (Action action : actions) {
                        this.addAction(action);
                    }
                }));
            }

            public void objectsRemoved(Iterable<Integer> indeces, Iterable<Action> objects) {
                this.execute((IBlock<RuntimeException>)((IBlock)() -> {
                    for (Action action : objects) {
                        this.removeAction(action);
                    }
                }));
            }

            public void objectsUpdated(Iterable<Integer> indeces, Iterable<Action> oldObjects, Iterable<Action> newObjects) {
                this.execute((IBlock<RuntimeException>)((IBlock)() -> {
                    for (Action action : oldObjects) {
                        this.removeAction(action);
                    }
                    for (Action action : newObjects) {
                        this.addAction(action);
                    }
                }));
            }

            public void objectsChanged(Iterable<Action> oldObjects, Iterable<Action> newObjects) {
                this.execute((IBlock<RuntimeException>)((IBlock)() -> {
                    for (Action action : oldObjects) {
                        this.removeAction(action);
                    }
                    for (Action action : newObjects) {
                        this.addAction(action);
                    }
                }));
            }

            private void addAction(Action action) {
                if (this.counter.get() < this.limit) {
                    this.addVisible(action);
                } else {
                    this.addHidden(action);
                }
            }

            private void addHidden(Action action) {
                this.hiddenActions.add(action);
            }

            private void addVisible(Action action) {
                ActionListMenu.this.add(action);
                this.visibleActions.add(action);
                this.counter.incrementAndGet();
            }

            private void removeAction(Action action) {
                if (this.hiddenActions.contains(action)) {
                    this.hiddenActions.remove(action);
                } else if (this.visibleActions.contains(action)) {
                    this.visibleActions.remove(action);
                    ActionListMenu.this.remove(action);
                    int count = this.counter.decrementAndGet();
                    if (count < this.limit && !this.hiddenActions.isEmpty()) {
                        Action hiddenAction = this.hiddenActions.iterator().next();
                        this.hiddenActions.remove(hiddenAction);
                        this.addVisible(hiddenAction);
                    }
                }
            }
        });
    }

    void remove(Action action) {
        int i = 0;
        while (i < this.getItemCount()) {
            JMenuItem item = this.getItem(i);
            if (item.getAction().equals(action)) {
                this.remove(item);
                return;
            }
            ++i;
        }
    }
}

