/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.table.demo;

import de.jdemo.annotation.Demo;
import de.jdemo.extensions.SwingDemoCase;
import de.jdemo.junit.DemoAsTestRunner;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableModel;
import net.anwiba.commons.model.IChangeableObjectListener;
import net.anwiba.commons.model.IObjectModel;
import net.anwiba.commons.swing.object.StringField;
import net.anwiba.commons.swing.table.FilterableObjectTableModel;
import net.anwiba.commons.swing.table.IObjectTableModel;
import net.anwiba.commons.swing.table.IRowFilter;
import net.anwiba.commons.swing.table.SortableTable;
import net.anwiba.commons.swing.table.demo.DemoObjectFactory;
import net.anwiba.commons.swing.table.demo.DemoTableModel;
import net.anwiba.commons.swing.table.filter.ColumnToStingConverter;
import net.anwiba.commons.swing.table.filter.ContainsFilter;
import net.anwiba.commons.swing.table.filter.IColumToStringConverter;
import net.anwiba.commons.utilities.string.StringUtilities;
import org.junit.runner.RunWith;

@RunWith(value=DemoAsTestRunner.class)
public class SortableTableDemo
extends SwingDemoCase {
    @Demo
    public void sortable() {
        DemoObjectFactory factory = new DemoObjectFactory(4711L);
        this.show(new JScrollPane((Component)new SortableTable((TableModel)((Object)new DemoTableModel(factory.createObjectList(20))))));
    }

    @Demo
    public void filterable() {
        DemoObjectFactory factory = new DemoObjectFactory(4711L);
        DemoTableModel tableModel = new DemoTableModel(factory.createObjectList(20));
        final FilterableObjectTableModel filterableObjectTableModel = new FilterableObjectTableModel((IObjectTableModel)tableModel);
        JPanel panel = new JPanel(new BorderLayout());
        StringField stringField = new StringField();
        final IObjectModel model = stringField.getModel();
        model.addChangeListener(new IChangeableObjectListener(){

            public void objectChanged() {
                String value = (String)model.get();
                if (StringUtilities.isNullOrTrimmedEmpty((String)value)) {
                    filterableObjectTableModel.setRowFilter(null);
                    return;
                }
                filterableObjectTableModel.setRowFilter((IRowFilter)new ContainsFilter(value, (IColumToStringConverter)new ColumnToStingConverter(new int[]{0, 1, 2, 3})));
            }
        });
        panel.add((Component)stringField.getComponent(), "North");
        panel.add((Component)new JScrollPane((Component)new SortableTable((TableModel)filterableObjectTableModel)), "Center");
        this.show(panel);
    }
}

