/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.action;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.lang.reflect.InvocationTargetException;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import net.anwiba.commons.lang.object.IObjectProvider;
import net.anwiba.commons.swing.action.IProgressActionConfiguration;
import net.anwiba.commons.swing.dialog.exception.ExceptionDialog;
import net.anwiba.commons.swing.dialog.progress.ProgressDialog;

public abstract class AbstractProgressAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private final IObjectProvider<Window> ownerProvider;

    public AbstractProgressAction(IObjectProvider<Window> ownerProvider, String title, Icon icon) {
        super(title, icon);
        this.ownerProvider = ownerProvider;
    }

    protected Window getOwner() {
        return (Window)this.ownerProvider.get();
    }

    protected abstract IProgressActionConfiguration getProgressActionConfiguration();

    @Override
    public final void actionPerformed(ActionEvent e) {
        IProgressActionConfiguration configuration = this.getProgressActionConfiguration();
        if (configuration == null) {
            return;
        }
        try {
            ProgressDialog.show(this.getOwner(), configuration.getMessage(), configuration.getProgressTask());
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException exception) {
            ExceptionDialog.show(this.getOwner(), exception.getCause());
        }
    }
}

