/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.action;

import java.awt.Component;
import net.anwiba.commons.model.BooleanModel;
import net.anwiba.commons.model.IBooleanModel;
import net.anwiba.commons.swing.action.ActionCustomization;
import net.anwiba.commons.swing.action.IActionConfiguration;
import net.anwiba.commons.swing.action.IActionCustomization;
import net.anwiba.commons.swing.action.IActionProcedure;
import net.anwiba.commons.swing.icon.IGuiIcon;

public class ActionConfigurationBuilder {
    private IBooleanModel enabledModel = new BooleanModel(true);
    private String tooltip = null;
    private IGuiIcon icon = null;
    private String name = null;
    private IActionProcedure procedure = null;
    private IGuiIcon selectedIcon = null;

    public ActionConfigurationBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public ActionConfigurationBuilder setSelectedIcon(IGuiIcon selectedIcon) {
        this.selectedIcon = selectedIcon;
        return this;
    }

    public ActionConfigurationBuilder setIcon(IGuiIcon icon) {
        this.icon = icon;
        return this;
    }

    public ActionConfigurationBuilder setTooltip(String tooltip) {
        this.tooltip = tooltip;
        return this;
    }

    public ActionConfigurationBuilder setEnabledModel(IBooleanModel enabledModel) {
        this.enabledModel = enabledModel;
        return this;
    }

    public ActionConfigurationBuilder setProcedure(IActionProcedure closure) {
        this.procedure = closure;
        return this;
    }

    public IActionConfiguration build() {
        final IBooleanModel enabledModel = this.enabledModel;
        final ActionCustomization customization = new ActionCustomization(this.name, this.icon, this.tooltip);
        final IActionProcedure procedure = this.procedure == null ? new IActionProcedure(){

            @Override
            public void execute(Component value) throws RuntimeException {
            }
        } : this.procedure;
        return new IActionConfiguration(){

            @Override
            public IBooleanModel getEnabledModel() {
                return enabledModel;
            }

            @Override
            public IActionCustomization getCustomization() {
                return customization;
            }

            @Override
            public IActionProcedure getProcedure() {
                return procedure;
            }
        };
    }
}

