/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.dialog;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import javax.swing.SwingUtilities;
import net.anwiba.commons.lang.functional.IFunction;
import net.anwiba.commons.message.IMessage;
import net.anwiba.commons.model.IObjectModel;
import net.anwiba.commons.model.ObjectModel;
import net.anwiba.commons.preferences.IPreferences;
import net.anwiba.commons.swing.dialog.ConfigurableDialog;
import net.anwiba.commons.swing.dialog.DialogConfigurationBuilder;
import net.anwiba.commons.swing.dialog.DialogMessages;
import net.anwiba.commons.swing.dialog.DialogType;
import net.anwiba.commons.swing.dialog.IAdditionalActionFactory;
import net.anwiba.commons.swing.dialog.IContentPaneFactory;
import net.anwiba.commons.swing.dialog.IDialogConfiguration;
import net.anwiba.commons.swing.dialog.IDialogResult;
import net.anwiba.commons.swing.icon.GuiIcon;
import net.anwiba.commons.swing.icon.IGuiIcon;
import net.anwiba.commons.swing.utilities.GuiUtilities;

public class ConfigurableDialogLauncher {
    private final DialogConfigurationBuilder dialogConfigurationBuilder = new DialogConfigurationBuilder();

    public ConfigurableDialogLauncher setIcon(GuiIcon icon) {
        this.dialogConfigurationBuilder.setIcon((IGuiIcon)icon);
        return this;
    }

    public ConfigurableDialogLauncher setCloseButtonDialog() {
        this.dialogConfigurationBuilder.setDialogType(DialogType.CLOSE);
        return this;
    }

    public ConfigurableDialogLauncher setCancleOkButtonDialog() {
        this.dialogConfigurationBuilder.setDialogType(DialogType.CANCEL_OK);
        return this;
    }

    public ConfigurableDialogLauncher setDialogType(DialogType dialogType) {
        this.dialogConfigurationBuilder.setDialogType(dialogType);
        return this;
    }

    public ConfigurableDialogLauncher setActionButtonTextFactory(IFunction<String, String, RuntimeException> factory) {
        this.dialogConfigurationBuilder.setActionButtonTextFactory(factory);
        return this;
    }

    public ConfigurableDialogLauncher setTitle(String title) {
        this.dialogConfigurationBuilder.setTitle(title);
        return this;
    }

    public ConfigurableDialogLauncher setContentPaneFactory(IContentPaneFactory contentPaneFactory) {
        this.dialogConfigurationBuilder.setContentPaneFactory(contentPaneFactory);
        return this;
    }

    public ConfigurableDialogLauncher setPreferences(IPreferences preferences) {
        this.dialogConfigurationBuilder.setPreferences(preferences);
        return this;
    }

    public ConfigurableDialogLauncher enableCloseOnEscape() {
        this.dialogConfigurationBuilder.setDialogCloseKeyEvent(27);
        return this;
    }

    public ConfigurableDialogLauncher setResizeable() {
        this.dialogConfigurationBuilder.setResizeable(true);
        return this;
    }

    public ConfigurableDialogLauncher setUnresizeable() {
        this.dialogConfigurationBuilder.setResizeable(false);
        return this;
    }

    public ConfigurableDialogLauncher addAdditionalAction(IAdditionalActionFactory factory) {
        this.dialogConfigurationBuilder.addAdditionalAction(factory);
        return this;
    }

    public ConfigurableDialogLauncher setMessage(IMessage message) {
        this.dialogConfigurationBuilder.setMessage(message);
        this.dialogConfigurationBuilder.setMessagePanelEnabled(message != null);
        return this;
    }

    public ConfigurableDialogLauncher setOkButtonText(String string) {
        this.dialogConfigurationBuilder.setActionButtonTextFactory((IFunction<String, String, RuntimeException>)((IFunction)s -> s.equals(DialogMessages.OK) ? string : s));
        return this;
    }

    public ConfigurableDialogLauncher setPreferdSize(int width, int height) {
        this.dialogConfigurationBuilder.setPreferdSize(new Dimension(width, height));
        return this;
    }

    public IDialogResult launch(Component component) {
        return this.launch(component == null ? null : SwingUtilities.windowForComponent(component));
    }

    public IDialogResult launch(Window owner) {
        ObjectModel model = new ObjectModel();
        GuiUtilities.invokeAndWait(() -> this.lambda$1(owner, (IObjectModel)model));
        return (IDialogResult)model.get();
    }

    private /* synthetic */ void lambda$1(Window window, IObjectModel iObjectModel) {
        IDialogConfiguration configuration = this.dialogConfigurationBuilder.build();
        ConfigurableDialog dialog = new ConfigurableDialog(window, configuration);
        dialog.setVisible(true);
        dialog.toFront();
        iObjectModel.set((Object)dialog.getResult());
    }
}

