/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.dialog.progress;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import net.anwiba.commons.lang.object.IObjectContainer;
import net.anwiba.commons.lang.object.ObjectContainer;
import net.anwiba.commons.message.IMessage;
import net.anwiba.commons.message.Message;
import net.anwiba.commons.message.MessageType;
import net.anwiba.commons.process.cancel.Canceler;
import net.anwiba.commons.process.cancel.ICanceler;
import net.anwiba.commons.progress.IProgressMonitor;
import net.anwiba.commons.progress.IProgressTask;
import net.anwiba.commons.swing.dialog.DialogResult;
import net.anwiba.commons.swing.dialog.DialogType;
import net.anwiba.commons.swing.dialog.MessageDialog;
import net.anwiba.commons.swing.dialog.progress.IProgressBarParent;
import net.anwiba.commons.swing.icon.GuiIcons;
import net.anwiba.commons.swing.utilities.GuiUtilities;

public class ProgressDialog
extends MessageDialog
implements IProgressBarParent {
    private static final long serialVersionUID = 1L;
    private final ICanceler canceler = new Canceler(true);
    private final IProgressMonitor progressMonitor;
    private final JPanel contentPane = new JPanel();

    public ProgressDialog(Window owner, IMessage message) {
        super(owner, message.getText(), message, (Icon)GuiIcons.INFORMATION_ICON.getLargeIcon(), DialogType.CANCEL);
        this.contentPane.setLayout(new FlowLayout(1));
        this.contentPane.setPreferredSize(new Dimension(20, 40));
        this.contentPane.setBorder(BorderFactory.createEmptyBorder(8, 4, 8, 4));
        this.setContentPane(this.contentPane);
        this.progressMonitor = new ProgressMonitor(this, message.getText());
        this.setResizable(false);
        this.locate();
    }

    @Override
    protected boolean cancel() {
        this.canceler.cancel();
        return false;
    }

    public ICanceler getCanceler() {
        return this.canceler;
    }

    public IProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    public static <O, E extends Exception> O show(Window owner, IMessage message, final IProgressTask<O, E> task) throws E, InterruptedException {
        final ProgressDialog dialog = new ProgressDialog(owner, message);
        final IProgressMonitor progressMonitor = dialog.getProgressMonitor();
        ObjectContainer exceptionContainer = new ObjectContainer();
        ObjectContainer resultContainer = new ObjectContainer();
        Thread thread = new Thread(new Runnable((IObjectContainer)resultContainer, (IObjectContainer)exceptionContainer){
            private final /* synthetic */ IObjectContainer val$resultContainer;
            private final /* synthetic */ IObjectContainer val$exceptionContainer;
            {
                this.val$resultContainer = iObjectContainer;
                this.val$exceptionContainer = iObjectContainer2;
            }

            @Override
            public void run() {
                try {
                    try {
                        progressMonitor.start();
                        Object result = task.run(progressMonitor, dialog.getCanceler());
                        this.val$resultContainer.set(result);
                    }
                    catch (Exception exception) {
                        this.val$exceptionContainer.set((Object)exception);
                        progressMonitor.finished();
                    }
                }
                finally {
                    progressMonitor.finished();
                }
            }
        });
        thread.start();
        GuiUtilities.invokeAndWait(() -> dialog.setVisible(true));
        Exception exception = (Exception)exceptionContainer.get();
        if (exception != null) {
            if (exception instanceof InterruptedException) {
                throw (InterruptedException)exception;
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw exception;
        }
        if (DialogResult.CANCEL.equals(dialog.getResult())) {
            throw new InterruptedException();
        }
        return (O)resultContainer.get();
    }

    @Override
    public void add(JProgressBar progressBar) {
        GuiUtilities.invokeLater(() -> {
            this.contentPane.add(progressBar);
            this.contentPane.revalidate();
        });
    }

    public static final class ProgressMonitor
    implements IProgressMonitor {
        private static final long serialVersionUID = 1L;
        private final String messageText;
        private final List<IMessage> messages = new ArrayList<IMessage>();
        final JProgressBar progressBar = new JProgressBar();
        final IProgressBarParent parent;

        public ProgressMonitor(IProgressBarParent parent, String messageText) {
            this.parent = parent;
            this.messageText = messageText;
        }

        public void setValue(int value) {
            GuiUtilities.invokeLater(() -> this.progressBar.setValue(value));
        }

        public void start() {
            GuiUtilities.invokeLater(() -> {
                this.progressBar.setIndeterminate(true);
                this.parent.add(this.progressBar);
            });
        }

        public void start(int value, int maximum) {
            GuiUtilities.invokeLater(() -> {
                this.progressBar.setMaximum(maximum);
                this.progressBar.setValue(value);
                this.parent.add(this.progressBar);
            });
        }

        public void finished() {
            GuiUtilities.invokeLater(() -> {
                this.parent.setVisible(false);
                this.parent.dispose();
            });
        }

        public void setNote(String note) {
            GuiUtilities.invokeLater(() -> this.parent.setMessage(Message.create((String)this.messageText, (String)note, (MessageType)MessageType.DEFAULT)));
        }

        public void addMessage(IMessage message) {
            GuiUtilities.invokeLater(() -> this.messages.add(message));
        }
    }
}

