/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.menu;

import java.io.Serializable;
import java.util.Comparator;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import net.anwiba.commons.swing.menu.AbstractMenuItemConfiguration;
import net.anwiba.commons.swing.menu.AbstractMenuItemDescription;
import net.anwiba.commons.swing.menu.MenuDescription;
import net.anwiba.commons.swing.menu.MenuItemButtomFactory;
import net.anwiba.commons.swing.menu.MenuItemGroupConfiguration;
import net.anwiba.commons.swing.menu.MenuItemGroupDescription;
import net.anwiba.commons.swing.menu.MenuType;
import net.anwiba.commons.utilities.registry.KeyValueRegistry;

public class MenuConfiguration {
    private final MenuType menuType;
    private final MenuDescription description;
    private final KeyValueRegistry<MenuItemGroupDescription, MenuItemGroupConfiguration> registry = new KeyValueRegistry();
    final Comparator<MenuItemGroupDescription> comparator = new MenuItemGroupDescriptionComarator();

    public MenuConfiguration(MenuDescription description) {
        this(description, MenuType.MENU);
    }

    public MenuConfiguration(MenuDescription description, MenuType menuType) {
        this.description = description;
        this.menuType = menuType;
    }

    public MenuDescription getDescription() {
        return this.description;
    }

    public MenuItemGroupConfiguration get(MenuItemGroupDescription description) {
        return (MenuItemGroupConfiguration)this.registry.get((Object)description);
    }

    public void add(MenuItemGroupConfiguration menuGroup) {
        this.registry.register((Object)menuGroup.getDescription(), (Object)menuGroup);
    }

    public void remove(MenuItemGroupConfiguration menuGroup) {
        this.registry.remove((Object)menuGroup.getDescription());
    }

    public JMenu getJMenu() {
        MenuItemGroupConfiguration[] menuGroups = (MenuItemGroupConfiguration[])this.registry.getItems(this.comparator, MenuItemGroupDescription.class, MenuItemGroupConfiguration.class);
        JMenu menu = this.createMenu();
        menu.setName(this.description.getId());
        int i = 0;
        while (i < menuGroups.length) {
            int n;
            if (i > 0) {
                menu.addSeparator();
            }
            AbstractMenuItemConfiguration<? extends AbstractMenuItemDescription>[] menuItemConfigurations = menuGroups[i].getMenuItemConfiguration();
            if (menuGroups[i].getDescription().isToggelGroup()) {
                ButtonGroup group = new ButtonGroup();
                AbstractMenuItemConfiguration<? extends AbstractMenuItemDescription>[] abstractMenuItemConfigurationArray = menuItemConfigurations;
                int n2 = menuItemConfigurations.length;
                n = 0;
                while (n < n2) {
                    AbstractMenuItemConfiguration<? extends AbstractMenuItemDescription> menuItemConfiguration = abstractMenuItemConfigurationArray[n];
                    AbstractButton button = this.addToMenu(menu, menuItemConfiguration);
                    group.add(button);
                    ++n;
                }
            } else {
                AbstractMenuItemConfiguration<? extends AbstractMenuItemDescription>[] abstractMenuItemConfigurationArray = menuItemConfigurations;
                n = menuItemConfigurations.length;
                int n3 = 0;
                while (n3 < n) {
                    AbstractMenuItemConfiguration<? extends AbstractMenuItemDescription> menuItemConfiguration = abstractMenuItemConfigurationArray[n3];
                    this.addToMenu(menu, menuItemConfiguration);
                    ++n3;
                }
            }
            ++i;
        }
        return menu;
    }

    private JMenu createMenu() {
        JMenu menu = (JMenu)this.description.getMenuFactory().create((Object)this.description.getTitle());
        return menu;
    }

    private AbstractButton addToMenu(JMenu menu, AbstractMenuItemConfiguration<?> menuItemConfiguration) {
        MenuItemButtomFactory visitor = new MenuItemButtomFactory(menu, menuItemConfiguration);
        return ((AbstractMenuItemDescription)menuItemConfiguration.getDescription()).getMenuItemType().accept(visitor);
    }

    public boolean isEmpty() {
        return this.registry.isEmpty();
    }

    public MenuType getMenuType() {
        return this.menuType;
    }

    public static final class MenuItemGroupDescriptionComarator
    implements Comparator<MenuItemGroupDescription>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(MenuItemGroupDescription o1, MenuItemGroupDescription o2) {
            return Integer.valueOf(o1.getWeight()).compareTo(o2.getWeight());
        }
    }
}

