/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.object;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import net.anwiba.commons.lang.functional.IBlock;
import net.anwiba.commons.lang.functional.IConverter;
import net.anwiba.commons.model.IObjectModel;
import net.anwiba.commons.model.ObjectModel;
import net.anwiba.commons.swing.action.ConfigurableActionBuilder;
import net.anwiba.commons.swing.action.IActionProcedure;
import net.anwiba.commons.swing.icon.GuiIcons;
import net.anwiba.commons.swing.icon.IGuiIcon;
import net.anwiba.commons.swing.object.DefaultObjectFieldConfiguration;
import net.anwiba.commons.swing.object.IActionFactory;
import net.anwiba.commons.swing.object.IObjectFieldConfiguration;
import net.anwiba.commons.swing.object.IToolTipFactory;
import net.anwiba.commons.utilities.string.StringUtilities;
import net.anwiba.commons.utilities.validation.IValidationResult;
import net.anwiba.commons.utilities.validation.IValidator;

public abstract class AbstractObjectFieldConfigurationBuilder<T, C extends AbstractObjectFieldConfigurationBuilder<T, C>> {
    private boolean isEditable = true;
    private int columns = 10;
    private IValidator<String> validator;
    private IConverter<String, T, RuntimeException> toObjectConverter;
    private IConverter<T, String, RuntimeException> toStringConverter;
    private IToolTipFactory toolTipFactory = new IToolTipFactory(){

        @Override
        public String create(IValidationResult validationResult, String text) {
            if (!validationResult.isValid()) {
                return validationResult.getMessage();
            }
            if (StringUtilities.isNullOrEmpty((String)text)) {
                return null;
            }
            return text;
        }
    };
    private IObjectModel<IValidationResult> validStateModel = new ObjectModel((Object)IValidationResult.valid());
    private IObjectModel<T> model = new ObjectModel();
    private final List<IActionFactory<T>> actionFactorys = new ArrayList<IActionFactory<T>>();

    public AbstractObjectFieldConfigurationBuilder(IValidator<String> validator, IConverter<String, T, RuntimeException> toObjectConverter, IConverter<T, String, RuntimeException> toStringConverter) {
        this.validator = validator;
        this.toObjectConverter = toObjectConverter;
        this.toStringConverter = toStringConverter;
    }

    public IObjectFieldConfiguration<T> build() {
        return new DefaultObjectFieldConfiguration<T>(this.model, this.validStateModel, this.validator, this.toObjectConverter, this.toStringConverter, this.toolTipFactory, this.isEditable, this.columns, this.actionFactorys);
    }

    public C setToolTipFactory(IToolTipFactory factory) {
        this.toolTipFactory = factory;
        return (C)this;
    }

    public C setModel(IObjectModel<T> model) {
        this.model = model;
        return (C)this;
    }

    public C setValidStateModel(IObjectModel<IValidationResult> validStateModel) {
        this.validStateModel = validStateModel;
        return (C)this;
    }

    public C setValidator(IValidator<String> validator) {
        this.validator = validator;
        return (C)this;
    }

    public C setToObjectConverter(IConverter<String, T, RuntimeException> toObjectConverter) {
        this.toObjectConverter = toObjectConverter;
        return (C)this;
    }

    public C setToStringConverter(IConverter<T, String, RuntimeException> toStringConverter) {
        this.toStringConverter = toStringConverter;
        return (C)this;
    }

    public C setEditable(boolean isEditable) {
        this.isEditable = isEditable;
        return (C)this;
    }

    public C setColumns(int columns) {
        this.columns = columns;
        return (C)this;
    }

    public C addActionFactory(IActionFactory<T> actionFactory) {
        this.actionFactorys.add(actionFactory);
        return (C)this;
    }

    public C addClearAction(final String tooltip) {
        this.addActionFactory(new IActionFactory<T>(){

            @Override
            public AbstractAction create(IObjectModel<T> context, final Document document, final IBlock<RuntimeException> clearBlock) throws RuntimeException {
                ConfigurableActionBuilder builder = new ConfigurableActionBuilder();
                final AbstractAction action = builder.setIcon((IGuiIcon)GuiIcons.EDIT_CLEAR_LOCATIONBAR_ICON).setTooltip(tooltip).setProcedure(new IActionProcedure(){

                    @Override
                    public void execute(Component value) throws RuntimeException {
                        clearBlock.execute();
                    }
                }).build();
                action.setEnabled(document.getLength() != 0);
                document.addDocumentListener(new DocumentListener(){

                    @Override
                    public void removeUpdate(DocumentEvent e) {
                        action.setEnabled(document.getLength() != 0);
                    }

                    @Override
                    public void insertUpdate(DocumentEvent e) {
                        action.setEnabled(document.getLength() != 0);
                    }

                    @Override
                    public void changedUpdate(DocumentEvent e) {
                        action.setEnabled(document.getLength() != 0);
                    }
                });
                return action;
            }
        });
        return (C)this;
    }
}

