/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.object;

import java.util.regex.Pattern;
import net.anwiba.commons.swing.object.AbstractObjectFieldBuilder;
import net.anwiba.commons.swing.object.AbstractObjectTextField;
import net.anwiba.commons.swing.object.IObjectFieldConfiguration;
import net.anwiba.commons.swing.object.StringField;
import net.anwiba.commons.swing.object.StringObjectFieldConfigurationBuilder;
import net.anwiba.commons.utilities.string.StringUtilities;
import net.anwiba.commons.utilities.validation.IValidationResult;
import net.anwiba.commons.utilities.validation.IValidator;

public class StringFieldBuilder
extends AbstractObjectFieldBuilder<String, StringObjectFieldConfigurationBuilder, StringFieldBuilder> {
    public StringFieldBuilder() {
        super(new StringObjectFieldConfigurationBuilder());
    }

    @Override
    protected AbstractObjectTextField<String> create(IObjectFieldConfiguration<String> configuration) {
        return new StringField(configuration);
    }

    public AbstractObjectFieldBuilder<String, StringObjectFieldConfigurationBuilder, StringFieldBuilder> setRegularExpressionValidator(final String patternString, final String message) {
        final Pattern pattern = Pattern.compile(patternString);
        ((StringObjectFieldConfigurationBuilder)this.getConfigurationBuilder()).setValidator(new IValidator<String>(){

            public IValidationResult validate(String value) {
                if (StringUtilities.isNullOrTrimmedEmpty((String)value)) {
                    return IValidationResult.inValid((String)message);
                }
                pattern.matcher(value).matches();
                if (!value.matches(patternString)) {
                    return IValidationResult.inValid((String)message);
                }
                return IValidationResult.valid();
            }
        });
        return this;
    }

    public StringFieldBuilder setToolTip(String tooltipText) {
        ((StringObjectFieldConfigurationBuilder)this.getConfigurationBuilder()).setToolTipFactory((validationResult, text) -> {
            if (!validationResult.isValid()) {
                return validationResult.getMessage();
            }
            return tooltipText;
        });
        return this;
    }
}

